/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.fetcher.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.plugin.fetcher.internal.FetcherConfigurationClassFinder;
import io.gravitee.plugin.fetcher.internal.FetcherPluginImpl;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class FetcherPluginHandler
extends AbstractSimplePluginHandler<FetcherPlugin> {
    @Autowired
    private ConfigurablePluginManager<FetcherPlugin> fetcherPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "fetcher".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "fetchers";
    }

    protected ClassLoader getClassLoader(Plugin plugin) throws Exception {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected FetcherPlugin create(Plugin plugin, Class<?> pluginClass) {
        FetcherPluginImpl fetcher = new FetcherPluginImpl(plugin, pluginClass);
        fetcher.setConfiguration(new FetcherConfigurationClassFinder().lookupFirst(pluginClass));
        return fetcher;
    }

    protected void register(FetcherPlugin plugin) {
        this.fetcherPluginManager.register((Plugin)plugin);
    }
}

