/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.RouteMatch;
import io.grpc.xds.XdsRoutingLoadBalancer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class XdsRoutingLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public XdsRoutingLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    XdsRoutingLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "xds_routing_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new XdsRoutingLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Map actions = JsonUtil.getObject(rawConfig, (String)"action");
            if (actions == null || actions.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No actions provided for xds_routing LB policy: " + rawConfig));
            }
            LinkedHashMap<String, ServiceConfigUtil.PolicySelection> parsedActions = new LinkedHashMap<String, ServiceConfigUtil.PolicySelection>();
            for (String name : actions.keySet()) {
                Map rawAction = JsonUtil.getObject((Map)actions, (String)name);
                if (rawAction == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No config for action " + name + " in xds_routing LB policy: " + rawConfig));
                }
                ServiceConfigUtil.PolicySelection parsedAction = XdsRoutingLoadBalancerProvider.parseAction(rawAction, this.lbRegistry == null ? LoadBalancerRegistry.getDefaultRegistry() : this.lbRegistry);
                parsedActions.put(name, parsedAction);
            }
            ArrayList<Route> parsedRoutes = new ArrayList<Route>();
            List rawRoutes = JsonUtil.getListOfObjects(rawConfig, (String)"route");
            if (rawRoutes == null || rawRoutes.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No routes provided for xds_routing LB policy: " + rawConfig));
            }
            for (Map rawRoute : rawRoutes) {
                Route route = XdsRoutingLoadBalancerProvider.parseRoute(rawRoute);
                if (!parsedActions.containsKey(route.getActionName())) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No action defined for route " + route + " in xds_routing LB policy: " + rawConfig));
                }
                parsedRoutes.add(route);
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new XdsRoutingConfig(parsedRoutes, parsedActions));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse xds_routing LB config: " + rawConfig));
        }
    }

    private static ServiceConfigUtil.PolicySelection parseAction(Map<String, ?> rawAction, LoadBalancerRegistry registry) {
        List childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawAction, (String)"childPolicy"));
        if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
            throw new RuntimeException("childPolicy not specified");
        }
        NameResolver.ConfigOrError selectedConfigOrError = ServiceConfigUtil.selectLbPolicyFromList((List)childConfigCandidates, (LoadBalancerRegistry)registry);
        if (selectedConfigOrError.getError() != null) {
            throw selectedConfigOrError.getError().asRuntimeException();
        }
        return (ServiceConfigUtil.PolicySelection)selectedConfigOrError.getConfig();
    }

    private static Route parseRoute(Map<String, ?> rawRoute) {
        try {
            String actionName;
            String pathExact = JsonUtil.getString(rawRoute, (String)"path");
            String pathPrefix = JsonUtil.getString(rawRoute, (String)"prefix");
            Pattern pathRegex = null;
            String rawPathRegex = JsonUtil.getString(rawRoute, (String)"regex");
            if (rawPathRegex != null) {
                try {
                    pathRegex = Pattern.compile((String)rawPathRegex);
                }
                catch (PatternSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!XdsRoutingLoadBalancerProvider.isOneOf(pathExact, pathPrefix, pathRegex)) {
                throw new RuntimeException("must specify exactly one patch match type");
            }
            RouteMatch.PathMatcher pathMatcher = new RouteMatch.PathMatcher(pathExact, pathPrefix, pathRegex);
            ArrayList<RouteMatch.HeaderMatcher> headers = new ArrayList<RouteMatch.HeaderMatcher>();
            List rawHeaders = JsonUtil.getListOfObjects(rawRoute, (String)"headers");
            if (rawHeaders != null) {
                for (Map rawHeader : rawHeaders) {
                    RouteMatch.HeaderMatcher headerMatcher = XdsRoutingLoadBalancerProvider.parseHeaderMatcher(rawHeader);
                    headers.add(headerMatcher);
                }
            }
            RouteMatch.FractionMatcher matchFraction = null;
            Map rawFraction = JsonUtil.getObject(rawRoute, (String)"matchFraction");
            if (rawFraction != null) {
                matchFraction = XdsRoutingLoadBalancerProvider.parseFractionMatcher(rawFraction);
            }
            if ((actionName = JsonUtil.getString(rawRoute, (String)"action")) == null) {
                throw new RuntimeException("action name not specified");
            }
            return new Route(new RouteMatch(pathMatcher, headers, matchFraction), actionName);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to parse Route: " + e.getMessage());
        }
    }

    private static RouteMatch.HeaderMatcher parseHeaderMatcher(Map<String, ?> rawHeaderMatcher) {
        try {
            String suffixMatch;
            String prefixMatch;
            Boolean presentMatch;
            Map rawRangeMatch;
            RouteMatch.HeaderMatcher.Range rangeMatch;
            String name = JsonUtil.getString(rawHeaderMatcher, (String)"name");
            if (name == null) {
                throw new RuntimeException("header name not specified");
            }
            String exactMatch = JsonUtil.getString(rawHeaderMatcher, (String)"exactMatch");
            Pattern regexMatch = null;
            String rawRegex = JsonUtil.getString(rawHeaderMatcher, (String)"regexMatch");
            if (rawRegex != null) {
                try {
                    regexMatch = Pattern.compile((String)rawRegex);
                }
                catch (PatternSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!XdsRoutingLoadBalancerProvider.isOneOf(exactMatch, regexMatch, rangeMatch = (rawRangeMatch = JsonUtil.getObject(rawHeaderMatcher, (String)"rangeMatch")) == null ? null : XdsRoutingLoadBalancerProvider.parseHeaderRange(rawRangeMatch), presentMatch = JsonUtil.getBoolean(rawHeaderMatcher, (String)"presentMatch"), prefixMatch = JsonUtil.getString(rawHeaderMatcher, (String)"prefixMatch"), suffixMatch = JsonUtil.getString(rawHeaderMatcher, (String)"suffixMatch"))) {
                throw new RuntimeException("must specify exactly one match type");
            }
            Boolean inverted = JsonUtil.getBoolean(rawHeaderMatcher, (String)"invertMatch");
            return new RouteMatch.HeaderMatcher(name, exactMatch, regexMatch, rangeMatch, presentMatch, prefixMatch, suffixMatch, inverted == null ? false : inverted);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to parse HeaderMatcher: " + e.getMessage());
        }
    }

    private static boolean isOneOf(Object ... objects) {
        int count = 0;
        for (Object o : objects) {
            if (o == null) continue;
            ++count;
        }
        return count == 1;
    }

    private static RouteMatch.HeaderMatcher.Range parseHeaderRange(Map<String, ?> rawRange) {
        try {
            Long start = JsonUtil.getNumberAsLong(rawRange, (String)"start");
            if (start == null) {
                throw new RuntimeException("start not specified");
            }
            Long end = JsonUtil.getNumberAsLong(rawRange, (String)"end");
            if (end == null) {
                throw new RuntimeException("end not specified");
            }
            return new RouteMatch.HeaderMatcher.Range(start, end);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to parse Range: " + e.getMessage());
        }
    }

    private static RouteMatch.FractionMatcher parseFractionMatcher(Map<String, ?> rawFraction) {
        try {
            Integer numerator = JsonUtil.getNumberAsInteger(rawFraction, (String)"numerator");
            if (numerator == null) {
                throw new RuntimeException("numerator not specified");
            }
            Integer denominator = JsonUtil.getNumberAsInteger(rawFraction, (String)"denominator");
            if (denominator == null) {
                throw new RuntimeException("denominator not specified");
            }
            return new RouteMatch.FractionMatcher(numerator, denominator);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to parse Fraction: " + e.getMessage());
        }
    }

    static final class Route {
        private final RouteMatch routeMatch;
        private final String actionName;

        Route(RouteMatch routeMatch, String actionName) {
            this.routeMatch = routeMatch;
            this.actionName = actionName;
        }

        String getActionName() {
            return this.actionName;
        }

        RouteMatch getRouteMatch() {
            return this.routeMatch;
        }

        public int hashCode() {
            return Objects.hash(this.routeMatch, this.actionName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route that = (Route)o;
            return Objects.equals(this.actionName, that.actionName) && Objects.equals(this.routeMatch, that.routeMatch);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routeMatch", (Object)this.routeMatch).add("actionName", (Object)this.actionName).toString();
        }
    }

    static final class XdsRoutingConfig {
        final List<Route> routes;
        final Map<String, ServiceConfigUtil.PolicySelection> actions;

        @VisibleForTesting
        XdsRoutingConfig(List<Route> routes, Map<String, ServiceConfigUtil.PolicySelection> actions) {
            this.routes = ImmutableList.copyOf(routes);
            this.actions = ImmutableMap.copyOf(actions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XdsRoutingConfig that = (XdsRoutingConfig)o;
            return Objects.equals(this.routes, that.routes) && Objects.equals(this.actions, that.actions);
        }

        public int hashCode() {
            return Objects.hash(this.routes, this.actions);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routes", this.routes).add("actions", this.actions).toString();
        }
    }
}

