/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.ScanOutput;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import java.nio.ByteBuffer;

public class ScoredValueScanStreamingOutput<K, V>
extends ScanOutput<K, V, StreamScanCursor> {
    private final ScoredValueStreamingChannel<V> channel;
    private V value;

    public ScoredValueScanStreamingOutput(RedisCodec<K, V> codec, ScoredValueStreamingChannel<V> channel) {
        super(codec, new StreamScanCursor());
        this.channel = channel;
    }

    @Override
    protected void setOutput(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = LettuceStrings.toDouble(this.decodeAscii(bytes));
        this.set(score);
    }

    @Override
    public void set(double number) {
        this.channel.onValue(ScoredValue.fromNullable(number, this.value));
        this.value = null;
        ((StreamScanCursor)this.output).setCount(((StreamScanCursor)this.output).getCount() + 1L);
    }
}

