/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.util;

import com.google.common.reflect.TypeToken;
import io.github.ningyu.jmeter.plugin.dubbo.sample.MethodArgument;
import io.github.ningyu.jmeter.plugin.util.Constants;
import io.github.ningyu.jmeter.plugin.util.JsonUtils;
import io.github.ningyu.jmeter.plugin.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ClassUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String TYPE_NAME_PREFIX = "class ";

    public static String getClassName(Type type) {
        if (type == null) {
            return "";
        }
        String className = type.toString();
        if (className.startsWith(TYPE_NAME_PREFIX)) {
            className = className.substring(TYPE_NAME_PREFIX.length());
        }
        return className;
    }

    public static String[] getMethodParamType(String interfaceName, String methodName) {
        try {
            Method[] methods;
            Class<?> class1 = Class.forName(interfaceName);
            for (Method method : methods = class1.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] paramClassList = method.getParameterTypes();
                String[] paramTypeList = new String[paramClassList.length];
                int i = 0;
                for (Class<?> className : paramClassList) {
                    paramTypeList[i] = className.getName();
                    ++i;
                }
                return paramTypeList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void parseParameter(List<String> paramterTypeList, List<Object> parameterValuesList, MethodArgument arg) {
        try {
            String className = arg.getParamType();
            if ("int".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? 0 : Integer.parseInt(arg.getParamValue()));
            } else if ("int[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.INT_ARRAY_DEFAULT : (int[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<int[]>(){}.getType()));
            } else if ("double".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? 0.0 : Double.parseDouble(arg.getParamValue()));
            } else if ("double[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.DOUBLE_ARRAY_DEFAULT : (double[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<double[]>(){}.getType()));
            } else if ("short".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? (short)0 : Short.parseShort(arg.getParamValue()));
            } else if ("short[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.SHORT_ARRAY_DEFAULT : (short[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<short[]>(){}.getType()));
            } else if ("float".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(Float.valueOf(StringUtils.isBlank(arg.getParamValue()) ? 0.0f : Float.parseFloat(arg.getParamValue())));
            } else if ("float[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.FLOAT_ARRAY_DEFAULT : (float[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<float[]>(){}.getType()));
            } else if ("long".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? 0L : Long.parseLong(arg.getParamValue()));
            } else if ("long[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.LONG_ARRAY_DEFAULT : (long[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<long[]>(){}.getType()));
            } else if ("byte".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? (byte)0 : Byte.parseByte(arg.getParamValue()));
            } else if ("byte[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.BYTE_ARRAY_DEFAULT : (byte[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<byte[]>(){}.getType()));
            } else if ("boolean".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? false : Boolean.parseBoolean(arg.getParamValue()));
            } else if ("boolean[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.BOOLEAN_ARRAY_DEFAULT : (boolean[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<boolean[]>(){}.getType()));
            } else if ("char".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(Character.valueOf(StringUtils.isBlank(arg.getParamValue()) ? (char)'\u0000' : arg.getParamValue().charAt(0)));
            } else if ("char[]".equals(className)) {
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? Constants.CHAT_ARRAY_DEFAULT : (char[])JsonUtils.fromJson(arg.getParamValue(), new TypeToken<char[]>(){}.getType()));
            } else if ("java.lang.String".equals(className) || "String".equals(className) || "string".equals(className)) {
                paramterTypeList.add("java.lang.String");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : String.valueOf(arg.getParamValue()));
            } else if ("java.lang.String[]".equals(className) || "String[]".equals(className) || "string[]".equals(className)) {
                paramterTypeList.add("java.lang.String[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<String[]>(){}.getType()));
            } else if ("java.lang.Integer".equals(className) || "Integer".equals(className) || "integer".equals(className)) {
                paramterTypeList.add("java.lang.Integer");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Integer.valueOf(arg.getParamValue()));
            } else if ("java.lang.Integer[]".equals(className) || "Integer[]".equals(className) || "integer[]".equals(className)) {
                paramterTypeList.add("java.lang.Integer[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Integer[]>(){}.getType()));
            } else if ("java.lang.Double".equals(className) || "Double".equals(className)) {
                paramterTypeList.add("java.lang.Double");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Double.valueOf(arg.getParamValue()));
            } else if ("java.lang.Double[]".equals(className) || "Double[]".equals(className)) {
                paramterTypeList.add("java.lang.Double[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Double[]>(){}.getType()));
            } else if ("java.lang.Short".equals(className) || "Short".equals(className)) {
                paramterTypeList.add("java.lang.Short");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Short.valueOf(arg.getParamValue()));
            } else if ("java.lang.Short[]".equals(className) || "Short[]".equals(className)) {
                paramterTypeList.add("java.lang.Short[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Short[]>(){}.getType()));
            } else if ("java.lang.Long".equals(className) || "Long".equals(className)) {
                paramterTypeList.add("java.lang.Long");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Long.valueOf(arg.getParamValue()));
            } else if ("java.lang.Long[]".equals(className) || "Long[]".equals(className)) {
                paramterTypeList.add("java.lang.Long[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Long[]>(){}.getType()));
            } else if ("java.lang.Float".equals(className) || "Float".equals(className)) {
                paramterTypeList.add("java.lang.Float");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Float.valueOf(arg.getParamValue()));
            } else if ("java.lang.Float[]".equals(className) || "Float[]".equals(className)) {
                paramterTypeList.add("java.lang.Float[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Float[]>(){}.getType()));
            } else if ("java.lang.Byte".equals(className) || "Byte".equals(className)) {
                paramterTypeList.add("java.lang.Byte");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Byte.valueOf(arg.getParamValue()));
            } else if ("java.lang.Byte[]".equals(className) || "Byte[]".equals(className)) {
                paramterTypeList.add("java.lang.Byte[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Byte[]>(){}.getType()));
            } else if ("java.lang.Boolean".equals(className) || "Boolean".equals(className)) {
                paramterTypeList.add("java.lang.Boolean");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : Boolean.valueOf(arg.getParamValue()));
            } else if ("java.lang.Boolean[]".equals(className) || "Boolean[]".equals(className)) {
                paramterTypeList.add("java.lang.Boolean[]");
                parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<Boolean[]>(){}.getType()));
            } else if ("java.util.Locale".equals(className)) {
                paramterTypeList.add("java.util.Locale");
                parameterValuesList.add(ClassUtils.parseLocale(arg.getParamValue()));
            } else if ("java.util.Locale[]".equals(className)) {
                paramterTypeList.add("java.util.Locale[]");
                List list = (List)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<List<String>>(){}.getType());
                ArrayList<Locale> localeList = new ArrayList<Locale>();
                for (String locale : list) {
                    localeList.add(ClassUtils.parseLocale(locale));
                }
                parameterValuesList.add(localeList.toArray(new Locale[localeList.size()]));
            } else if ("java.time.LocalDateTime".equals(className)) {
                paramterTypeList.add("java.time.LocalDateTime");
                parameterValuesList.add(LocalDateTime.parse(arg.getParamValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            } else if ("java.time.LocalDate".equals(className)) {
                paramterTypeList.add("java.time.LocalDate");
                LocalDateTime localDateTime = LocalDateTime.parse(arg.getParamValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                parameterValuesList.add(localDateTime.toLocalDate());
            } else if ("java.time.LocalTime".equals(className)) {
                paramterTypeList.add("java.time.LocalTime");
                LocalDateTime localDateTime = LocalDateTime.parse(arg.getParamValue(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                parameterValuesList.add(localDateTime.toLocalTime());
            } else if (className.endsWith("[]")) {
                List list = null;
                if (!StringUtils.isBlank(arg.getParamValue())) {
                    list = (List)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<List<?>>(){}.getType());
                }
                paramterTypeList.add(arg.getParamType());
                parameterValuesList.add(list == null ? null : list.toArray());
            } else {
                try {
                    Class<?> clazz = Class.forName(className);
                    paramterTypeList.add(arg.getParamType());
                    parameterValuesList.add(StringUtils.isBlank(arg.getParamValue()) ? null : (Object)JsonUtils.fromJson(arg.getParamValue(), clazz));
                }
                catch (ClassNotFoundException e) {
                    paramterTypeList.add(arg.getParamType());
                    String obj = null;
                    if (!StringUtils.isBlank(arg.getParamValue()) && (obj = (String)JsonUtils.fromJson(arg.getParamValue(), new TypeToken<HashMap<String, Object>>(){}.getType())) == null) {
                        obj = JsonUtils.fromJson(arg.getParamValue(), String.class);
                    }
                    parameterValuesList.add(obj);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid parameter => [ParamType=" + arg.getParamType() + ",ParamValue=" + arg.getParamValue() + "]", e);
        }
    }

    public static Locale parseLocale(String locale) {
        switch (locale) {
            case "ENGLISH": {
                return Locale.ENGLISH;
            }
            case "FRENCH": {
                return Locale.FRENCH;
            }
            case "GERMAN": {
                return Locale.GERMAN;
            }
            case "ITALIAN": {
                return Locale.ITALIAN;
            }
            case "JAPANESE": {
                return Locale.JAPANESE;
            }
            case "KOREAN": {
                return Locale.KOREAN;
            }
            case "CHINESE": {
                return Locale.CHINESE;
            }
            case "SIMPLIFIED_CHINESE": {
                return Locale.SIMPLIFIED_CHINESE;
            }
            case "TRADITIONAL_CHINESE": {
                return Locale.TRADITIONAL_CHINESE;
            }
            case "FRANCE": {
                return Locale.FRANCE;
            }
            case "GERMANY": {
                return Locale.GERMANY;
            }
            case "ITALY": {
                return Locale.ITALY;
            }
            case "JAPAN": {
                return Locale.JAPAN;
            }
            case "KOREA": {
                return Locale.KOREA;
            }
            case "CHINA": {
                return Locale.CHINA;
            }
            case "PRC": {
                return Locale.PRC;
            }
            case "TAIWAN": {
                return Locale.TAIWAN;
            }
            case "UK": {
                return Locale.UK;
            }
            case "US": {
                return Locale.US;
            }
            case "CANADA": {
                return Locale.CANADA;
            }
            case "CANADA_FRENCH": {
                return Locale.CANADA_FRENCH;
            }
        }
        return Locale.ROOT;
    }
}

