/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation.tck;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class TestObservationRegistry
implements ObservationRegistry {
    private final ObservationRegistry delegate = ObservationRegistry.create();
    private final ArrayListObservationHandler handler = new ArrayListObservationHandler();

    private TestObservationRegistry() {
        this.observationConfig().observationHandler((ObservationHandler)this.handler);
    }

    public static TestObservationRegistry create() {
        return new TestObservationRegistry();
    }

    public Observation getCurrentObservation() {
        return this.delegate.getCurrentObservation();
    }

    public Observation.Scope getCurrentObservationScope() {
        return this.delegate.getCurrentObservationScope();
    }

    public void setCurrentObservationScope(Observation.Scope current) {
        this.delegate.setCurrentObservationScope(current);
    }

    public ObservationRegistry.ObservationConfig observationConfig() {
        return this.delegate.observationConfig();
    }

    Queue<TestObservationContext> getContexts() {
        return this.handler.contexts;
    }

    private static class ArrayListObservationHandler
    implements ObservationHandler<Observation.Context> {
        final Queue<TestObservationContext> contexts = new ConcurrentLinkedQueue<TestObservationContext>();

        private ArrayListObservationHandler() {
        }

        public void onStart(Observation.Context context) {
            this.contexts.add(new TestObservationContext(context).setObservationStarted(true));
        }

        public void onStop(Observation.Context context) {
            this.contexts.stream().filter(testContext -> testContext.getContext() == context).findFirst().ifPresent(testContext -> testContext.setObservationStopped(true));
        }

        public boolean supportsContext(Observation.Context context) {
            return true;
        }
    }

    static class TestObservationContext {
        private final Observation.Context context;
        private boolean observationStarted;
        private boolean observationStopped;

        TestObservationContext(Observation.Context context) {
            this.context = context;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestObservationContext that = (TestObservationContext)o;
            return Objects.equals(this.context, that.context);
        }

        public int hashCode() {
            return Objects.hash(this.context);
        }

        TestObservationContext setObservationStarted(boolean observationStarted) {
            this.observationStarted = observationStarted;
            return this;
        }

        TestObservationContext setObservationStopped(boolean observationStopped) {
            this.observationStopped = observationStopped;
            return this;
        }

        boolean isObservationStarted() {
            return this.observationStarted;
        }

        boolean isObservationStopped() {
            return this.observationStopped;
        }

        Observation.Context getContext() {
            return this.context;
        }
    }
}

