/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.StringUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;

class SimpleObservation
implements Observation {
    private final ObservationRegistry registry;
    private final Observation.Context context;
    @Nullable
    private ObservationConvention convention;
    private final Deque<ObservationHandler> handlers;
    private final Collection<ObservationFilter> filters;
    private final ThreadLocal<Deque<Observation.Scope>> enclosingScopes = ThreadLocal.withInitial(ArrayDeque::new);

    SimpleObservation(@Nullable String name, ObservationRegistry registry, Observation.Context context) {
        this.registry = registry;
        this.context = context;
        this.context.setName(name);
        this.convention = SimpleObservation.getConventionFromConfig(registry, context);
        this.handlers = SimpleObservation.getHandlersFromConfig(registry, context);
        this.filters = registry.observationConfig().getObservationFilters();
        this.setParentFromCurrentObservation();
    }

    SimpleObservation(ObservationConvention<? extends Observation.Context> convention, ObservationRegistry registry, Observation.Context context) {
        this.registry = registry;
        this.context = context;
        this.handlers = SimpleObservation.getHandlersFromConfig(registry, context);
        this.filters = registry.observationConfig().getObservationFilters();
        if (!convention.supportsContext(context)) {
            throw new IllegalStateException("Convention [" + convention + "] doesn't support context [" + context + "]");
        }
        this.convention = convention;
        this.setParentFromCurrentObservation();
    }

    private void setParentFromCurrentObservation() {
        Observation currentObservation = this.registry.getCurrentObservation();
        if (currentObservation != null) {
            this.context.setParentObservation(currentObservation);
        }
    }

    @Nullable
    private static ObservationConvention getConventionFromConfig(ObservationRegistry registry, Observation.Context context) {
        for (ObservationConvention<?> convention : registry.observationConfig().getObservationConventions()) {
            if (!convention.supportsContext(context)) continue;
            return convention;
        }
        return null;
    }

    private static Deque<ObservationHandler> getHandlersFromConfig(ObservationRegistry registry, Observation.Context context) {
        Collection<ObservationHandler<?>> handlers = registry.observationConfig().getObservationHandlers();
        ArrayDeque<ObservationHandler> deque = new ArrayDeque<ObservationHandler>(handlers.size());
        for (ObservationHandler<?> handler : handlers) {
            if (!handler.supportsContext(context)) continue;
            deque.add(handler);
        }
        return deque;
    }

    @Override
    public Observation contextualName(@Nullable String contextualName) {
        this.context.setContextualName(contextualName);
        return this;
    }

    @Override
    public Observation parentObservation(@Nullable Observation parentObservation) {
        this.context.setParentObservation(parentObservation);
        return this;
    }

    @Override
    public Observation lowCardinalityKeyValue(KeyValue keyValue) {
        this.context.addLowCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation highCardinalityKeyValue(KeyValue keyValue) {
        this.context.addHighCardinalityKeyValue(keyValue);
        return this;
    }

    @Override
    public Observation observationConvention(ObservationConvention<?> convention) {
        if (convention.supportsContext(this.context)) {
            this.convention = convention;
        }
        return this;
    }

    @Override
    public Observation error(Throwable error) {
        this.context.setError(error);
        this.notifyOnError();
        return this;
    }

    @Override
    public Observation event(Observation.Event event) {
        this.notifyOnEvent(event);
        return this;
    }

    @Override
    public Observation start() {
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            String newName = this.convention.getName();
            if (StringUtils.isNotBlank((String)newName)) {
                this.context.setName(newName);
            }
        }
        this.notifyOnObservationStarted();
        return this;
    }

    @Override
    public Observation.Context getContext() {
        return this.context;
    }

    @Override
    public void stop() {
        if (this.convention != null) {
            this.context.addLowCardinalityKeyValues(this.convention.getLowCardinalityKeyValues(this.context));
            this.context.addHighCardinalityKeyValues(this.convention.getHighCardinalityKeyValues(this.context));
            String newContextualName = this.convention.getContextualName(this.context);
            if (StringUtils.isNotBlank((String)newContextualName)) {
                this.context.setContextualName(newContextualName);
            }
        }
        Observation.Context modifiedContext = this.context;
        for (ObservationFilter filter : this.filters) {
            modifiedContext = filter.map(modifiedContext);
        }
        this.notifyOnObservationStopped(modifiedContext);
        this.enclosingScopes.remove();
    }

    @Override
    public Observation.Scope openScope() {
        Deque<Observation.Scope> scopes = this.enclosingScopes.get();
        Observation.Scope currentScope = this.registry.getCurrentObservationScope();
        if (currentScope != null) {
            scopes.addFirst(currentScope);
        }
        SimpleScope scope = new SimpleScope(this.registry, this);
        this.notifyOnScopeOpened();
        return scope;
    }

    @Override
    @Nullable
    public Observation.Scope getEnclosingScope() {
        Deque<Observation.Scope> scopes = this.enclosingScopes.get();
        if (!scopes.isEmpty()) {
            return scopes.getFirst();
        }
        return null;
    }

    public String toString() {
        return "{name=" + this.context.getName() + "(" + this.context.getContextualName() + "), error=" + this.context.getError() + ", context=" + this.context + '}';
    }

    private void notifyOnObservationStarted() {
        for (ObservationHandler handler : this.handlers) {
            handler.onStart(this.context);
        }
    }

    private void notifyOnError() {
        for (ObservationHandler handler : this.handlers) {
            handler.onError(this.context);
        }
    }

    private void notifyOnEvent(Observation.Event event) {
        for (ObservationHandler handler : this.handlers) {
            handler.onEvent(event, this.context);
        }
    }

    private void notifyOnScopeOpened() {
        for (ObservationHandler handler : this.handlers) {
            handler.onScopeOpened(this.context);
        }
    }

    private void notifyOnScopeClosed() {
        Iterator<ObservationHandler> iterator = this.handlers.descendingIterator();
        while (iterator.hasNext()) {
            ObservationHandler handler = iterator.next();
            handler.onScopeClosed(this.context);
        }
    }

    private void notifyOnScopeMakeCurrent() {
        for (ObservationHandler handler : this.handlers) {
            handler.onScopeOpened(this.context);
        }
    }

    private void notifyOnScopeReset() {
        for (ObservationHandler handler : this.handlers) {
            handler.onScopeReset(this.context);
        }
    }

    private void notifyOnObservationStopped(Observation.Context context) {
        this.handlers.descendingIterator().forEachRemaining(handler -> handler.onStop(context));
    }

    static class SimpleScope
    implements Observation.Scope {
        private final ObservationRegistry registry;
        private final SimpleObservation currentObservation;
        @Nullable
        private final Observation.Scope previousObservationScope;

        SimpleScope(ObservationRegistry registry, SimpleObservation current) {
            this.registry = registry;
            this.currentObservation = current;
            this.previousObservationScope = registry.getCurrentObservationScope();
            this.registry.setCurrentObservationScope(this);
        }

        @Override
        public Observation getCurrentObservation() {
            return this.currentObservation;
        }

        @Override
        public void close() {
            Deque enclosingScopes = (Deque)this.currentObservation.enclosingScopes.get();
            if (!enclosingScopes.isEmpty()) {
                enclosingScopes.removeFirst();
            }
            this.registry.setCurrentObservationScope(this.previousObservationScope);
            this.currentObservation.notifyOnScopeClosed();
        }

        @Override
        public void reset() {
            this.registry.setCurrentObservationScope(null);
            SimpleScope scope = this;
            while (scope != null) {
                this.registry.setCurrentObservationScope(scope.previousObservationScope);
                scope.currentObservation.notifyOnScopeReset();
                SimpleScope simpleScope = scope;
                scope = (SimpleScope)simpleScope.previousObservationScope;
            }
        }

        @Override
        public void makeCurrent() {
            this.currentObservation.notifyOnScopeReset();
            Deque scopeDeque = (Deque)this.currentObservation.enclosingScopes.get();
            if (!scopeDeque.isEmpty()) {
                scopeDeque.removeFirst();
            }
            ArrayDeque<SimpleScope> scopes = new ArrayDeque<SimpleScope>();
            SimpleScope scope = this;
            while (scope != null) {
                scopes.addFirst(scope);
                scope = (SimpleScope)scope.previousObservationScope;
            }
            for (SimpleScope simpleScope : scopes) {
                simpleScope.currentObservation.notifyOnScopeMakeCurrent();
            }
        }
    }
}

