/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.elastic;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.lang.Nullable;
import java.util.regex.Pattern;

public class ElasticNamingConvention
implements NamingConvention {
    private static final Pattern FIRST_UNDERSCORE_PATTERN = Pattern.compile("^_+");
    private final NamingConvention delegate;

    public ElasticNamingConvention() {
        this(NamingConvention.snakeCase);
    }

    public ElasticNamingConvention(NamingConvention delegate) {
        this.delegate = delegate;
    }

    public String name(String name, Meter.Type type, @Nullable String baseUnit) {
        return this.delegate.name(name, type, baseUnit);
    }

    public String tagKey(String key) {
        if (key.equals("name")) {
            key = "name.tag";
        } else if (key.equals("type")) {
            key = "type.tag";
        } else if (key.startsWith("_")) {
            key = FIRST_UNDERSCORE_PATTERN.matcher(key).replaceFirst("");
        }
        return this.delegate.tagKey(key);
    }
}

