/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.influx;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.MeterRegistryConfigValidator;
import io.micrometer.core.instrument.config.validate.PropertyValidator;
import io.micrometer.core.instrument.config.validate.Validated;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.lang.Nullable;
import io.micrometer.influx.InfluxConsistency;
import java.util.function.Function;

public interface InfluxConfig
extends StepRegistryConfig {
    public static final InfluxConfig DEFAULT = k -> null;

    default public String prefix() {
        return "influx";
    }

    default public String db() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"db").orElse((Object)"mydb");
    }

    default public InfluxConsistency consistency() {
        return (InfluxConsistency)((Object)PropertyValidator.getEnum((MeterRegistryConfig)this, InfluxConsistency.class, (String)"consistency").orElse((Object)InfluxConsistency.ONE));
    }

    @Nullable
    default public String userName() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"userName").orElse(null);
    }

    @Nullable
    default public String password() {
        return (String)PropertyValidator.getSecret((MeterRegistryConfig)this, (String)"password").orElse(null);
    }

    @Nullable
    default public String retentionPolicy() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"retentionPolicy").orElse(null);
    }

    @Nullable
    default public String retentionDuration() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"retentionDuration").orElse(null);
    }

    @Nullable
    default public Integer retentionReplicationFactor() {
        return (Integer)PropertyValidator.getInteger((MeterRegistryConfig)this, (String)"retentionReplicationFactor").orElse(null);
    }

    @Nullable
    default public String retentionShardDuration() {
        return (String)PropertyValidator.getString((MeterRegistryConfig)this, (String)"retentionShardDuration").orElse(null);
    }

    default public String uri() {
        return (String)PropertyValidator.getUrlString((MeterRegistryConfig)this, (String)"uri").orElse((Object)"http://localhost:8086");
    }

    default public boolean compressed() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"compressed").orElse((Object)true);
    }

    default public boolean autoCreateDb() {
        return (Boolean)PropertyValidator.getBoolean((MeterRegistryConfig)this, (String)"autoCreateDb").orElse((Object)true);
    }

    default public Validated<?> validate() {
        return MeterRegistryConfigValidator.checkAll((MeterRegistryConfig)this, (Function[])new Function[]{c -> StepRegistryConfig.validate((StepRegistryConfig)c), MeterRegistryConfigValidator.checkRequired((String)"db", InfluxConfig::db), MeterRegistryConfigValidator.checkRequired((String)"consistency", InfluxConfig::consistency), MeterRegistryConfigValidator.checkRequired((String)"uri", InfluxConfig::uri)});
    }
}

