/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.ganglia;

import io.micrometer.core.instrument.Clock;
import io.micrometer.ganglia.GangliaConfig;
import io.micrometer.ganglia.GangliaMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.ganglia.GangliaProperties;
import io.micrometer.spring.autoconfigure.export.ganglia.GangliaPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={GangliaMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.ganglia", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GangliaProperties.class})
@Import(value={StringToDurationConverter.class})
public class GangliaMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GangliaConfig gangliaConfig(GangliaProperties props) {
        return new GangliaPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public GangliaMeterRegistry gangliaMeterRegistry(GangliaConfig config, Clock clock) {
        return new GangliaMeterRegistry(config, clock);
    }
}

