/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.statsd;

import io.micrometer.core.instrument.Clock;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.statsd.StatsdProperties;
import io.micrometer.spring.autoconfigure.export.statsd.StatsdPropertiesConfigAdapter;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micrometer.statsd.StatsdMetrics;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={StatsdMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.statsd", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={StatsdProperties.class})
@Import(value={StringToDurationConverter.class})
public class StatsdMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={StatsdConfig.class})
    public StatsdConfig statsdConfig(StatsdProperties props) {
        return new StatsdPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public StatsdMeterRegistry statsdMeterRegistry(StatsdConfig config, Clock clock) {
        return new StatsdMeterRegistry(config, clock);
    }

    @Bean
    public StatsdMetrics statsdMetrics() {
        return new StatsdMetrics();
    }
}

