/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationSource;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.EmptyAnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;

public interface AnnotationMetadata
extends AnnotationSource {
    public static final AnnotationMetadata EMPTY_METADATA = new EmptyAnnotationMetadata();
    public static final String VALUE_MEMBER = "value";
    public static final String CLASS_NAME_SUFFIX = "$$AnnotationMetadata";

    default public boolean hasPropertyExpressions() {
        return true;
    }

    @NonNull
    default public List<String> getAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Collections.emptyList();
    }

    @NonNull
    default public Set<String> getAnnotationNames() {
        return Collections.emptySet();
    }

    @NonNull
    default public Set<String> getDeclaredAnnotationNames() {
        return Collections.emptySet();
    }

    @NonNull
    default public List<String> getDeclaredAnnotationNamesByStereotype(@Nullable String stereotype) {
        return Collections.emptyList();
    }

    @NonNull
    default public <T> OptionalValues<T> getValues(@NonNull String annotation, @NonNull Class<T> valueType) {
        return OptionalValues.empty();
    }

    default public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        return Optional.empty();
    }

    @NonNull
    default public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return Collections.emptyList();
    }

    @NonNull
    default public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(@NonNull Class<T> annotationType) {
        return Collections.emptyList();
    }

    default public boolean hasDeclaredAnnotation(@Nullable String annotation) {
        return false;
    }

    default public boolean hasAnnotation(@Nullable String annotation) {
        return false;
    }

    default public boolean hasSimpleAnnotation(@Nullable String annotation) {
        if (annotation == null) {
            return false;
        }
        return this.getAnnotationNames().stream().anyMatch(a -> NameUtils.getSimpleName(a).equalsIgnoreCase(annotation));
    }

    default public boolean hasSimpleDeclaredAnnotation(@Nullable String annotation) {
        if (annotation == null) {
            return false;
        }
        return this.getDeclaredAnnotationNames().stream().anyMatch(a -> NameUtils.getSimpleName(a).equalsIgnoreCase(annotation));
    }

    default public boolean hasStereotype(@Nullable String annotation) {
        return false;
    }

    default public boolean hasDeclaredStereotype(@Nullable String annotation) {
        return false;
    }

    default public boolean hasDeclaredStereotype(String ... annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (String annotation : annotations) {
            if (!this.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    default public Map<String, Object> getDefaultValues(@NonNull String annotation) {
        return Collections.emptyMap();
    }

    default public <T> Optional<T> getDefaultValue(@NonNull String annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getDefaultValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getDefaultValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getDefaultValue(annotation.getName(), member, requiredType);
    }

    @Override
    default public boolean isAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        return this.hasAnnotation(annotationClass);
    }

    @Override
    default public boolean isDeclaredAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            return false;
        }
        return this.hasDeclaredAnnotation(annotationClass);
    }

    default public <T> Optional<T> getDefaultValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getDefaultValue(annotation.getName(), member, requiredType);
    }

    default public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<? extends Annotation>> values = this.getAnnotationValuesByType(annotation);
            if (!values.isEmpty()) {
                return values.iterator().next().get(member, requiredType);
            }
            return Optional.empty();
        }
        Optional<AnnotationValue<? extends Annotation>> values = this.findAnnotation(annotation);
        Optional value = values.flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public Optional<String> getAnnotationNameByStereotype(@Nullable String stereotype) {
        return this.getAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<String> getDeclaredAnnotationNameByStereotype(@Nullable String stereotype) {
        return this.getDeclaredAnnotationNamesByStereotype(stereotype).stream().findFirst();
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getDeclaredAnnotationTypeByStereotype(stereotype.getName());
    }

    default public Optional<Class<? extends Annotation>> getDeclaredAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.getDeclaredAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name, @NonNull ClassLoader classLoader) {
        ArgumentUtils.requireNonNull("name", name);
        Optional<Class> aClass = ClassUtils.forName(name, classLoader);
        return aClass.flatMap(aClass1 -> {
            if (Annotation.class.isAssignableFrom((Class<?>)aClass1)) {
                return Optional.of(aClass1);
            }
            return Optional.empty();
        });
    }

    default public Optional<Class<? extends Annotation>> getAnnotationType(@NonNull String name) {
        return this.getAnnotationType(name, this.getClass().getClassLoader());
    }

    default public Optional<Class<? extends Annotation>> getAnnotationTypeByStereotype(@Nullable String stereotype) {
        return this.getAnnotationNameByStereotype(stereotype).flatMap(this::getAnnotationType);
    }

    default public Optional<String> getAnnotationNameByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationNameByStereotype(stereotype.getName());
    }

    @NonNull
    default public <T> OptionalValues<T> getValues(@NonNull Class<? extends Annotation> annotation, @NonNull Class<T> valueType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("valueType", valueType);
        return this.getValues(annotation.getName(), valueType);
    }

    @NonNull
    default public List<String> getAnnotationNamesByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        return this.getAnnotationNamesByStereotype(stereotype.getName());
    }

    @NonNull
    default public List<Class<? extends Annotation>> getAnnotationTypesByStereotype(@NonNull Class<? extends Annotation> stereotype) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        List<String> names = this.getAnnotationNamesByStereotype(stereotype.getName());
        return names.stream().map(this::getAnnotationType).filter(Optional::isPresent).map(opt -> (Class)opt.get()).collect(Collectors.toList());
    }

    @NonNull
    default public List<Class<? extends Annotation>> getAnnotationTypesByStereotype(@NonNull Class<? extends Annotation> stereotype, @NonNull ClassLoader classLoader) {
        ArgumentUtils.requireNonNull("stereotype", stereotype);
        List<String> names = this.getAnnotationNamesByStereotype(stereotype.getName());
        return names.stream().map(name -> this.getAnnotationType((String)name, classLoader)).filter(Optional::isPresent).map(opt -> (Class)opt.get()).collect(Collectors.toList());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Repeatable repeatable = annotationClass.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getAnnotationValuesByType(annotationClass);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findAnnotation(annotationClass.getName());
    }

    @Override
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        Repeatable repeatable = annotationClass.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            List<AnnotationValue<T>> values = this.getDeclaredAnnotationValuesByType(annotationClass);
            if (!values.isEmpty()) {
                return Optional.of(values.iterator().next());
            }
            return Optional.empty();
        }
        return this.findDeclaredAnnotation(annotationClass.getName());
    }

    default public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    default public <T> Optional<T> getValue(@NonNull String annotation, @NonNull String member, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        Optional value = this.findAnnotation(annotation).flatMap(av -> av.get(member, requiredType));
        if (!value.isPresent() && this.hasStereotype(annotation)) {
            return this.getDefaultValue(annotation, member, requiredType);
        }
        return value;
    }

    default public OptionalLong longValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Long> result = this.getValue(annotation, member, Long.class);
        return result.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    default public OptionalLong longValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.longValue(annotation.getName(), member);
    }

    default public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValue(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValue(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> Optional<E> enumValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.enumValue(annotation.getName(), member, enumType);
    }

    default public <E extends Enum> E[] enumValues(@NonNull String annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValues(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> E[] enumValues(@NonNull String annotation, @NonNull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return (Enum[])Array.newInstance(enumType, 0);
    }

    default public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.enumValues(annotation, VALUE_MEMBER, enumType);
    }

    default public <E extends Enum> E[] enumValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member, Class<E> enumType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.enumValues(annotation.getName(), member, enumType);
    }

    @NonNull
    default public <T> Class<T>[] classValues(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValues(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public <T> Class<T>[] classValues(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Class[].class).orElse(ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    @NonNull
    default public <T> Class<T>[] classValues(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValues(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public <T> Class<T>[] classValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.classValues(annotation.getName(), member);
    }

    default public Optional<Class> classValue(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Class> classValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Class.class);
    }

    default public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.classValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Class> classValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.classValue(annotation.getName(), member);
    }

    default public OptionalInt intValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Integer> result = this.getValue(annotation, member, Integer.class);
        return result.map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    default public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.intValue(annotation.getName(), member);
    }

    default public OptionalInt intValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.intValue(annotation, VALUE_MEMBER);
    }

    default public Optional<String> stringValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, String.class);
    }

    default public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.stringValue(annotation.getName(), member);
    }

    @NonNull
    default public Optional<String> stringValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.stringValue(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public Optional<String> stringValue(@NonNull String annotation) {
        return this.stringValue(annotation, VALUE_MEMBER);
    }

    default public Optional<Boolean> booleanValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Boolean.class);
    }

    default public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.booleanValue(annotation.getName(), member);
    }

    @NonNull
    default public Optional<Boolean> booleanValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.booleanValue(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public Optional<Boolean> booleanValue(@NonNull String annotation) {
        return this.booleanValue(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public String[] stringValues(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    @NonNull
    default public String[] stringValues(@NonNull Class<? extends Annotation> annotation) {
        return this.stringValues(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public OptionalDouble doubleValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        Optional<Double> result = this.getValue(annotation, member, Double.class);
        return result.map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    @NonNull
    default public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.doubleValue(annotation.getName(), member);
    }

    @NonNull
    default public OptionalDouble doubleValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.doubleValue(annotation, VALUE_MEMBER);
    }

    @NonNull
    default public <T> Optional<T> getValue(@NonNull String annotation, @NonNull Class<T> requiredType) {
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @NonNull
    default public Optional<Object> getValue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Object.class);
    }

    @NonNull
    default public Optional<Object> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Object.class);
    }

    default public boolean isTrue(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation, member, Boolean.class).orElse(false);
    }

    default public boolean isTrue(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.getValue(annotation.getName(), member, Boolean.class).orElse(false);
    }

    default public boolean isPresent(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.findAnnotation(annotation).map(av -> av.contains(member)).orElse(false);
    }

    default public boolean isPresent(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return this.isPresent(annotation.getName(), member);
    }

    default public boolean isFalse(@NonNull Class<? extends Annotation> annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return !this.isTrue(annotation, member);
    }

    default public boolean isFalse(@NonNull String annotation, @NonNull String member) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("member", member);
        return !this.isTrue(annotation, member);
    }

    @NonNull
    default public Optional<Object> getValue(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getValue(annotation, Object.class);
    }

    @NonNull
    default public Optional<Object> getValue(@NonNull Class<? extends Annotation> annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.getValue(annotation, VALUE_MEMBER, Object.class);
    }

    @NonNull
    default public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull Class<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @NonNull
    default public <T> Optional<T> getValue(@NonNull Class<? extends Annotation> annotation, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    @NonNull
    default public <T> Optional<T> getValue(@NonNull String annotation, @NonNull Argument<T> requiredType) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        ArgumentUtils.requireNonNull("requiredType", requiredType);
        return this.getValue(annotation, VALUE_MEMBER, requiredType);
    }

    default public boolean hasAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasAnnotation(repeatable.value().getName());
            }
            return this.hasAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasStereotype(repeatable.value().getName());
            }
            return this.hasStereotype(annotation.getName());
        }
        return false;
    }

    default public boolean hasStereotype(Class<? extends Annotation> ... annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasStereotype(@Nullable String[] annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (String annotation : annotations) {
            if (!this.hasStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasDeclaredAnnotation(@Nullable Class<? extends Annotation> annotation) {
        if (annotation != null) {
            Repeatable repeatable = annotation.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredAnnotation(repeatable.value().getName());
            }
            return this.hasDeclaredAnnotation(annotation.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(@Nullable Class<? extends Annotation> stereotype) {
        if (stereotype != null) {
            Repeatable repeatable = stereotype.getAnnotation(Repeatable.class);
            if (repeatable != null) {
                return this.hasDeclaredStereotype(repeatable.value().getName());
            }
            return this.hasDeclaredStereotype(stereotype.getName());
        }
        return false;
    }

    default public boolean hasDeclaredStereotype(Class<? extends Annotation> ... annotations) {
        if (ArrayUtils.isEmpty(annotations)) {
            return false;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (!this.hasDeclaredStereotype(annotation)) continue;
            return true;
        }
        return false;
    }

    default public boolean isEmpty() {
        return this == EMPTY_METADATA;
    }
}

