/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.ArrayUtils;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Argument<T>
extends TypeInformation<T>,
AnnotatedElement,
Type {
    public static final Argument<String> STRING = Argument.of(String.class);
    public static final Argument<Integer> INT = Argument.of(Integer.TYPE);
    public static final Argument<Long> LONG = Argument.of(Long.TYPE);
    public static final Argument<Float> FLOAT = Argument.of(Float.TYPE);
    public static final Argument<Double> DOUBLE = Argument.of(Double.TYPE);
    public static final Argument<Void> VOID = Argument.of(Void.TYPE);
    public static final Argument<Byte> BYTE = Argument.of(Byte.TYPE);
    public static final Argument<Boolean> BOOLEAN = Argument.of(Boolean.TYPE);
    public static final Argument<Character> CHAR = Argument.of(Character.TYPE);
    public static final Argument<Short> SHORT = Argument.of(Short.TYPE);
    public static final Argument[] ZERO_ARGUMENTS = new Argument[0];
    public static final Argument<Object> OBJECT_ARGUMENT = Argument.of(Object.class);
    public static final Argument<List<String>> LIST_OF_STRING = Argument.listOf(String.class);
    public static final Argument<Void> VOID_OBJECT = Argument.of(Void.class);

    @Override
    @NonNull
    public String getName();

    public boolean equalsType(Argument<?> var1);

    public int typeHashCode();

    default public boolean isInstance(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        return this.getType().isInstance(o);
    }

    @NonNull
    public static Class[] toClassArray(Argument ... arguments) {
        if (ArrayUtils.isEmpty(arguments)) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Argument argument = arguments[i];
            types[i] = argument.getType();
        }
        return types;
    }

    @NonNull
    public static String toString(Argument ... arguments) {
        StringBuilder baseString = new StringBuilder();
        if (ArrayUtils.isNotEmpty(arguments)) {
            for (int i = 0; i < arguments.length; ++i) {
                Argument argument = arguments[i];
                baseString.append(argument.toString());
                if (i == arguments.length - 1) continue;
                baseString.append(',');
            }
        }
        return baseString.toString();
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, String name, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, String name, AnnotationMetadata annotationMetadata, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, name, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, AnnotationMetadata annotationMetadata, Argument ... typeParameters) {
        return new DefaultArgument<T>(type, annotationMetadata, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, String name) {
        return new DefaultArgument<T>(type, name, AnnotationMetadata.EMPTY_METADATA, ZERO_ARGUMENTS);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, Argument ... typeParameters) {
        if (ArrayUtils.isEmpty(typeParameters)) {
            return Argument.of(type);
        }
        return new DefaultArgument<T>(type, NameUtils.decapitalize(type.getSimpleName()), AnnotationMetadata.EMPTY_METADATA, typeParameters);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type) {
        return new DefaultArgument<T>(type, AnnotationMetadata.EMPTY_METADATA, ZERO_ARGUMENTS);
    }

    @NonNull
    public static <T> Argument<T> of(Class<T> type, Class<?> ... typeParameters) {
        int len;
        if (ArrayUtils.isEmpty(typeParameters)) {
            return Argument.of(type);
        }
        TypeVariable<Class<T>>[] parameters = type.getTypeParameters();
        if (parameters.length != (len = typeParameters.length)) {
            throw new IllegalArgumentException("Type parameter length does not match. Required: " + parameters.length + ", Specified: " + len);
        }
        Argument[] typeArguments = new Argument[len];
        for (int i = 0; i < parameters.length; ++i) {
            TypeVariable<Class<T>> parameter = parameters[i];
            typeArguments[i] = Argument.of(typeParameters[i], parameter.getName());
        }
        return new DefaultArgument<T>(type, AnnotationMetadata.EMPTY_METADATA, typeArguments);
    }

    @NonNull
    public static <T> Argument<List<T>> listOf(Class<T> type) {
        return Argument.of(List.class, type);
    }

    @NonNull
    public static <T> Argument<List<T>> listOf(Argument<T> type) {
        return Argument.of(List.class, type);
    }

    @NonNull
    public static <T> Argument<Set<T>> setOf(Class<T> type) {
        return Argument.of(Set.class, type);
    }

    @NonNull
    public static <T> Argument<Set<T>> setOf(Argument<T> type) {
        return Argument.of(Set.class, type);
    }

    @NonNull
    public static <K, V> Argument<Map<K, V>> mapOf(Class<K> keyType, Class<V> valueType) {
        return Argument.of(Map.class, keyType, valueType);
    }

    @NonNull
    public static <K, V> Argument<Map<K, V>> mapOf(Argument<K> keyType, Argument<V> valueType) {
        return Argument.of(Map.class, keyType, valueType);
    }
}

