/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.TypeInformationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;

@Internal
final class RuntimeTypeInformation {
    private static final Collection<TypeInformationProvider> TYPE_INFORMATION_PROVIDERS;

    RuntimeTypeInformation() {
    }

    static boolean isSpecifiedSingle(AnnotationMetadataProvider annotationMetadata) {
        for (TypeInformationProvider provider : TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isSpecifiedSingle(annotationMetadata)) continue;
            return true;
        }
        return false;
    }

    static boolean isSingle(Class<?> type) {
        for (TypeInformationProvider provider : TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isSingle(type)) continue;
            return true;
        }
        return false;
    }

    static boolean isReactive(Class<?> type) {
        for (TypeInformationProvider provider : TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isReactive(type)) continue;
            return true;
        }
        return false;
    }

    static boolean isCompletable(Class<?> type) {
        for (TypeInformationProvider provider : TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isCompletable(type)) continue;
            return true;
        }
        return false;
    }

    static <T> boolean isWrapperType(Class<T> type) {
        for (TypeInformationProvider provider : TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isWrapperType(type)) continue;
            return true;
        }
        return false;
    }

    static {
        ServiceLoader<TypeInformationProvider> loader = ServiceLoader.load(TypeInformationProvider.class);
        ArrayList<TypeInformationProvider> informationProviders = new ArrayList<TypeInformationProvider>(2);
        for (TypeInformationProvider informationProvider : loader) {
            informationProviders.add(informationProvider);
        }
        TYPE_INFORMATION_PROVIDERS = Collections.unmodifiableList(informationProviders);
    }
}

