/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.OriginatingElements;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Internal
public final class StaticOriginatingElements
implements OriginatingElements {
    public static final StaticOriginatingElements INSTANCE = new StaticOriginatingElements();
    private final Map<String, Element> originatingElements = new LinkedHashMap<String, Element>(5);

    private StaticOriginatingElements() {
    }

    @Override
    public void addOriginatingElement(@NonNull Element element) {
        Objects.requireNonNull(element, "Element cannot be null");
        this.originatingElements.put(element.getName(), element);
    }

    @Override
    @NonNull
    public Element[] getOriginatingElements() {
        return this.originatingElements.values().toArray(Element.EMPTY_ELEMENT_ARRAY);
    }

    public void clear() {
        this.originatingElements.clear();
    }
}

