/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.cloud.AbstractComputeInstanceMetadata;
import io.micronaut.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@Internal
public class ComputeInstanceMetadataResolverUtils {
    public static JsonNode readMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs, ObjectMapper objectMapper, Map<String, String> requestProperties) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            urlConnection.connect();
            try (InputStream in = urlConnection.getInputStream();){
                JsonNode jsonNode = objectMapper.readTree(in);
                return jsonNode;
            }
        }
        HttpURLConnection uc = (HttpURLConnection)urlConnection;
        uc.setConnectTimeout(connectionTimeoutMs);
        requestProperties.forEach(uc::setRequestProperty);
        uc.setReadTimeout(readTimeoutMs);
        uc.setRequestMethod(HttpMethod.GET.name());
        uc.setDoOutput(true);
        try (InputStream in = uc.getInputStream();){
            JsonNode jsonNode = objectMapper.readTree(in);
            return jsonNode;
        }
    }

    public static Optional<String> stringValue(JsonNode json, String key) {
        return Optional.ofNullable(json.findValue(key)).map(JsonNode::asText);
    }

    public static void populateMetadata(AbstractComputeInstanceMetadata instanceMetadata, Map<?, ?> metadata) {
        if (metadata != null) {
            HashMap<String, String> finalMetadata = new HashMap<String, String>(metadata.size());
            for (Map.Entry<?, ?> entry : metadata.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof String)) continue;
                finalMetadata.put(key.toString(), value.toString());
            }
            instanceMetadata.setMetadata(finalMetadata);
        }
    }
}

