/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.MetadataUtils;
import io.milvus.client.AbstractMilvusGrpcClient;
import io.milvus.client.MilvusClient;
import io.milvus.grpc.MilvusServiceGrpc;
import io.milvus.param.ConnectParam;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class MilvusServiceClient
extends AbstractMilvusGrpcClient {
    private final ManagedChannel channel;
    private final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub;
    private final MilvusServiceGrpc.MilvusServiceFutureStub futureStub;

    public MilvusServiceClient(@NonNull ConnectParam connectParam) {
        if (connectParam == null) {
            throw new NullPointerException("connectParam is marked non-null but is null");
        }
        Metadata metadata = new Metadata();
        metadata.put(Metadata.Key.of((String)"authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)connectParam.getAuthorization());
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)connectParam.getHost(), (int)connectParam.getPort()).usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).keepAliveTime(connectParam.getKeepAliveTimeMs(), TimeUnit.MILLISECONDS).keepAliveTimeout(connectParam.getKeepAliveTimeoutMs(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(connectParam.isKeepAliveWithoutCalls()).idleTimeout(connectParam.getIdleTimeoutMs(), TimeUnit.MILLISECONDS).intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
        if (connectParam.isSecure()) {
            builder.useTransportSecurity();
        }
        this.channel = builder.build();
        this.blockingStub = MilvusServiceGrpc.newBlockingStub((Channel)this.channel);
        this.futureStub = MilvusServiceGrpc.newFutureStub((Channel)this.channel);
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    protected boolean clientIsReady() {
        ConnectivityState state = this.channel.getState(false);
        return state != ConnectivityState.SHUTDOWN;
    }

    @Override
    public void close(long maxWaitSeconds) throws InterruptedException {
        this.channel.shutdownNow();
        this.channel.awaitTermination(maxWaitSeconds, TimeUnit.SECONDS);
    }

    @Override
    public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
        long timeoutMillis = timeoutUnit.toMillis(timeout);
        TimeoutInterceptor timeoutInterceptor = new TimeoutInterceptor(timeoutMillis);
        final MilvusServiceGrpc.MilvusServiceBlockingStub blockingStubTimeout = (MilvusServiceGrpc.MilvusServiceBlockingStub)this.blockingStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        final MilvusServiceGrpc.MilvusServiceFutureStub futureStubTimeout = (MilvusServiceGrpc.MilvusServiceFutureStub)this.futureStub.withInterceptors(new ClientInterceptor[]{timeoutInterceptor});
        return new AbstractMilvusGrpcClient(){

            @Override
            protected boolean clientIsReady() {
                return MilvusServiceClient.this.clientIsReady();
            }

            @Override
            protected MilvusServiceGrpc.MilvusServiceBlockingStub blockingStub() {
                return blockingStubTimeout;
            }

            @Override
            protected MilvusServiceGrpc.MilvusServiceFutureStub futureStub() {
                return futureStubTimeout;
            }

            @Override
            public void close(long maxWaitSeconds) throws InterruptedException {
                MilvusServiceClient.this.close(maxWaitSeconds);
            }

            @Override
            public MilvusClient withTimeout(long timeout, TimeUnit timeoutUnit) {
                return MilvusServiceClient.this.withTimeout(timeout, timeoutUnit);
            }
        };
    }

    private static class TimeoutInterceptor
    implements ClientInterceptor {
        private final long timeoutMillis;

        TimeoutInterceptor(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return next.newCall(method, callOptions.withDeadlineAfter(this.timeoutMillis, TimeUnit.MILLISECONDS));
        }
    }
}

