/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.bulkinsert;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class BulkInsertParam {
    private final String collectionName;
    private final String partitionName;
    private final List<String> files;
    private final Map<String, String> options = new HashMap<String, String>();

    private BulkInsertParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.files = builder.files;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "BulkInsertParam{collectionName='" + this.collectionName + '\'' + ", partitionName=" + this.partitionName + ", files=" + this.files.toString() + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public static final class Builder {
        private String collectionName;
        private String partitionName;
        private final List<String> files = new ArrayList<String>();

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        public Builder withFiles(@NonNull List<String> files) {
            if (files == null) {
                throw new NullPointerException("files is marked non-null but is null");
            }
            this.files.addAll(files);
            return this;
        }

        public Builder addFile(@NonNull String file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.files.add(file);
            return this;
        }

        public BulkInsertParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (this.files.isEmpty()) {
                throw new ParamException("File path is required");
            }
            for (String file : this.files) {
                if (!StringUtils.isEmpty((CharSequence)file)) continue;
                throw new ParamException("File path cannot be empty or null");
            }
            return new BulkInsertParam(this);
        }
    }
}

