/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.credential;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DeleteCredentialParam {
    private final String username;

    private DeleteCredentialParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.username = builder.username;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "DeleteCredentialParam{username='" + this.username + '\'' + '}';
    }

    public String getUsername() {
        return this.username;
    }

    public static final class Builder {
        private String username;

        private Builder() {
        }

        public Builder withUsername(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked non-null but is null");
            }
            this.username = username;
            return this;
        }

        public DeleteCredentialParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.username, "Username");
            return new DeleteCredentialParam(this);
        }
    }
}

