/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.index;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class DescribeIndexParam {
    private final String collectionName;
    private final String indexName;

    private DescribeIndexParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.indexName = builder.indexName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "DescribeIndexParam{collectionName='" + this.collectionName + '\'' + ", indexName='" + this.indexName + '\'' + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public static final class Builder {
        private String collectionName;
        private String indexName = "";

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public DescribeIndexParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            return new DescribeIndexParam(this);
        }
    }
}

