/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.resourcegroup;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class TransferNodeParam {
    private final String sourceGroupName;
    private final String targetGroupName;
    private final int nodeNumber;

    private TransferNodeParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.sourceGroupName = builder.sourceGroupName;
        this.targetGroupName = builder.targetGroupName;
        this.nodeNumber = builder.nodeNumber;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSourceGroupName() {
        return this.sourceGroupName;
    }

    public String getTargetGroupName() {
        return this.targetGroupName;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public String toString() {
        return "TransferNodeParam(sourceGroupName=" + this.getSourceGroupName() + ", targetGroupName=" + this.getTargetGroupName() + ", nodeNumber=" + this.getNodeNumber() + ")";
    }

    public static final class Builder {
        private String sourceGroupName;
        private String targetGroupName;
        private Integer nodeNumber;

        private Builder() {
        }

        public Builder withSourceGroupName(@NonNull String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is marked non-null but is null");
            }
            this.sourceGroupName = groupName;
            return this;
        }

        public Builder withTargetGroupName(@NonNull String groupName) {
            if (groupName == null) {
                throw new NullPointerException("groupName is marked non-null but is null");
            }
            this.targetGroupName = groupName;
            return this;
        }

        public Builder withNodeNumber(@NonNull Integer nodeNumber) {
            if (nodeNumber == null) {
                throw new NullPointerException("nodeNumber is marked non-null but is null");
            }
            this.nodeNumber = nodeNumber;
            return this;
        }

        public TransferNodeParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.sourceGroupName, "Source group name");
            ParamUtils.CheckNullEmptyString(this.targetGroupName, "Target group name");
            return new TransferNodeParam(this);
        }
    }
}

