/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.Authorizator;
import io.moquette.broker.IRetainedRepository;
import io.moquette.broker.MQTTConnection;
import io.moquette.broker.NettyUtils;
import io.moquette.broker.RetainedMessage;
import io.moquette.broker.RoutingResults;
import io.moquette.broker.Session;
import io.moquette.broker.SessionEventLoopGroup;
import io.moquette.broker.SessionRegistry;
import io.moquette.broker.Utils;
import io.moquette.broker.subscriptions.ISubscriptionsDirectory;
import io.moquette.broker.subscriptions.Subscription;
import io.moquette.broker.subscriptions.Topic;
import io.moquette.interception.BrokerInterceptor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PostOffice {
    private static final Logger LOG = LoggerFactory.getLogger(PostOffice.class);
    private static final Set<String> NO_FILTER = new HashSet<String>();
    private final Authorizator authorizator;
    private final ISubscriptionsDirectory subscriptions;
    private final IRetainedRepository retainedRepository;
    private SessionRegistry sessionRegistry;
    private BrokerInterceptor interceptor;
    private final FailedPublishCollection failedPublishes = new FailedPublishCollection();
    private final SessionEventLoopGroup sessionLoops;

    PostOffice(ISubscriptionsDirectory subscriptions, IRetainedRepository retainedRepository, SessionRegistry sessionRegistry, BrokerInterceptor interceptor, Authorizator authorizator, SessionEventLoopGroup sessionLoops) {
        this.authorizator = authorizator;
        this.subscriptions = subscriptions;
        this.retainedRepository = retainedRepository;
        this.sessionRegistry = sessionRegistry;
        this.interceptor = interceptor;
        this.sessionLoops = sessionLoops;
    }

    public void init(SessionRegistry sessionRegistry) {
        this.sessionRegistry = sessionRegistry;
    }

    public void fireWill(Session.Will will) {
        this.publish2Subscribers(will.payload, new Topic(will.topic), will.qos);
    }

    public void subscribeClientToTopics(MqttSubscribeMessage msg, String clientID, String username, MQTTConnection mqttConnection) {
        int messageID = Utils.messageId((MqttMessage)msg);
        List<MqttTopicSubscription> ackTopics = this.authorizator.verifyTopicsReadAccess(clientID, username, msg);
        MqttSubAckMessage ackMessage = this.doAckMessageFromValidateFilters(ackTopics, messageID);
        List<Subscription> newSubscriptions = ackTopics.stream().filter(req -> req.qualityOfService() != MqttQoS.FAILURE).map(req -> {
            Topic topic = new Topic(req.topicName());
            return new Subscription(clientID, topic, req.qualityOfService());
        }).collect(Collectors.toList());
        for (Subscription subscription : newSubscriptions) {
            this.subscriptions.add(subscription);
        }
        Session session = this.sessionRegistry.retrieve(clientID);
        session.addSubscriptions(newSubscriptions);
        mqttConnection.sendSubAckMessage(messageID, ackMessage);
        this.publishRetainedMessagesForSubscriptions(clientID, newSubscriptions);
        for (Subscription subscription : newSubscriptions) {
            this.interceptor.notifyTopicSubscribed(subscription, username);
        }
    }

    private void publishRetainedMessagesForSubscriptions(String clientID, List<Subscription> newSubscriptions) {
        Session targetSession = this.sessionRegistry.retrieve(clientID);
        for (Subscription subscription : newSubscriptions) {
            String topicFilter = subscription.getTopicFilter().toString();
            List<RetainedMessage> retainedMsgs = this.retainedRepository.retainedOnTopic(topicFilter);
            if (retainedMsgs.isEmpty()) continue;
            for (RetainedMessage retainedMsg : retainedMsgs) {
                MqttQoS retainedQos = retainedMsg.qosLevel();
                MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(subscription, retainedQos);
                ByteBuf payloadBuf = Unpooled.wrappedBuffer((byte[])retainedMsg.getPayload());
                targetSession.sendRetainedPublishOnSessionAtQos(retainedMsg.getTopic(), qos, payloadBuf);
                payloadBuf.release();
            }
        }
    }

    private MqttSubAckMessage doAckMessageFromValidateFilters(List<MqttTopicSubscription> topicFilters, int messageId) {
        ArrayList<Integer> grantedQoSLevels = new ArrayList<Integer>();
        for (MqttTopicSubscription req : topicFilters) {
            grantedQoSLevels.add(req.qualityOfService().value());
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckPayload payload = new MqttSubAckPayload(grantedQoSLevels);
        return new MqttSubAckMessage(fixedHeader, MqttMessageIdVariableHeader.from((int)messageId), payload);
    }

    public void unsubscribe(List<String> topics, MQTTConnection mqttConnection, int messageId) {
        String clientID = mqttConnection.getClientId();
        Session session = this.sessionRegistry.retrieve(clientID);
        if (session == null) {
            LOG.warn("Session not found when unsubscribing {}", (Object)clientID);
            mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
            return;
        }
        for (String t : topics) {
            Topic topic = new Topic(t);
            boolean validTopic = topic.isValid();
            if (!validTopic) {
                mqttConnection.dropConnection();
                LOG.warn("Topic filter is not valid. topics: {}, offending topic filter: {}", topics, (Object)topic);
                return;
            }
            LOG.trace("Removing subscription topic={}", (Object)topic);
            this.subscriptions.removeSubscription(topic, clientID);
            session.removeSubscription(topic);
            String username = NettyUtils.userName(mqttConnection.channel);
            this.interceptor.notifyTopicUnsubscribed(topic.toString(), clientID, username);
        }
        mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
    }

    CompletableFuture<Void> receivedPublishQos0(Topic topic, String username, String clientID, MqttPublishMessage msg) {
        if (!this.authorizator.canWrite(topic, username, clientID)) {
            LOG.error("client is not authorized to publish on topic: {}", (Object)topic);
            ReferenceCountUtil.release((Object)msg);
            return CompletableFuture.completedFuture(null);
        }
        RoutingResults publishResult = this.publish2Subscribers(msg.payload(), topic, MqttQoS.AT_MOST_ONCE);
        if (publishResult.isAllFailed()) {
            LOG.info("No one publish was successfully enqueued to session loops");
            ReferenceCountUtil.release((Object)msg);
            return CompletableFuture.completedFuture(null);
        }
        return publishResult.completableFuture().thenRun(() -> {
            if (msg.fixedHeader().isRetain()) {
                this.retainedRepository.cleanRetained(topic);
            }
            this.interceptor.notifyTopicPublished(msg, clientID, username);
            ReferenceCountUtil.release((Object)msg);
        });
    }

    RoutingResults receivedPublishQos1(MQTTConnection connection, Topic topic, String username, int messageID, MqttPublishMessage msg) {
        RoutingResults routes;
        topic.getTokens();
        if (!topic.isValid()) {
            LOG.warn("Invalid topic format, force close the connection");
            connection.dropConnection();
            ReferenceCountUtil.release((Object)msg);
            return RoutingResults.preroutingError();
        }
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientId, (Object)topic);
            ReferenceCountUtil.release((Object)msg);
            return RoutingResults.preroutingError();
        }
        ByteBuf payload = msg.payload();
        if (msg.fixedHeader().isDup()) {
            Set<String> failedClients = this.failedPublishes.listFailed(clientId, messageID);
            routes = this.publish2Subscribers(payload, topic, MqttQoS.AT_LEAST_ONCE, failedClients);
        } else {
            routes = this.publish2Subscribers(payload, topic, MqttQoS.AT_LEAST_ONCE);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("subscriber routes: {}", (Object)routes);
        }
        if (routes.isAllSuccess()) {
            connection.sendPubAck(messageID);
            this.manageRetain(topic, msg);
            this.interceptor.notifyTopicPublished(msg, clientId, username);
        } else {
            this.failedPublishes.insertAll(messageID, clientId, routes.failedRoutings);
        }
        ReferenceCountUtil.release((Object)msg);
        this.failedPublishes.removeAll(messageID, clientId, routes.successedRoutings);
        return routes;
    }

    private void manageRetain(Topic topic, MqttPublishMessage msg) {
        if (msg.fixedHeader().isRetain()) {
            if (!msg.payload().isReadable()) {
                this.retainedRepository.cleanRetained(topic);
            } else {
                this.retainedRepository.retain(topic, msg);
            }
        }
    }

    private RoutingResults publish2Subscribers(ByteBuf payload, Topic topic, MqttQoS publishingQos) {
        return this.publish2Subscribers(payload, topic, publishingQos, NO_FILTER);
    }

    private RoutingResults publish2Subscribers(ByteBuf payload, Topic topic, MqttQoS publishingQos, Set<String> filterTargetClients) {
        List<Subscription> topicMatchingSubscriptions = this.subscriptions.matchQosSharpening(topic);
        if (topicMatchingSubscriptions.isEmpty()) {
            LOG.trace("No matching subscriptions for topic: {}", (Object)topic);
            return new RoutingResults(Collections.emptyList(), Collections.emptyList(), CompletableFuture.completedFuture(null));
        }
        BatchingPublishesCollector collector = new BatchingPublishesCollector(this.sessionLoops);
        for (Subscription sub : topicMatchingSubscriptions) {
            if (filterTargetClients != NO_FILTER && !filterTargetClients.contains(sub.getClientId())) continue;
            collector.add(sub);
        }
        payload.retain(collector.countBatches());
        List<RouteResult> publishResults = collector.routeBatchedPublishes(batch -> {
            this.publishToSession(payload, topic, (Collection<Subscription>)batch, publishingQos);
            payload.release();
        });
        CompletableFuture[] publishFutures = (CompletableFuture[])publishResults.stream().filter(RouteResult::isSuccess).map(RouteResult::completableFuture).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> publishes = CompletableFuture.allOf(publishFutures);
        ArrayList<String> failedRoutings = new ArrayList<String>();
        ArrayList<String> successedRoutings = new ArrayList<String>();
        for (RouteResult rr : publishResults) {
            Collection<String> subscibersIds = collector.subscriberIdsByEventLoop(rr.clientId);
            if (rr.status == RouteResult.Status.FAIL) {
                failedRoutings.addAll(subscibersIds);
                payload.release();
                continue;
            }
            successedRoutings.addAll(subscibersIds);
        }
        return new RoutingResults(successedRoutings, failedRoutings, publishes);
    }

    private void publishToSession(ByteBuf payload, Topic topic, Collection<Subscription> subscriptions, MqttQoS publishingQos) {
        ByteBuf duplicate = payload.duplicate();
        for (Subscription sub : subscriptions) {
            MqttQoS qos = PostOffice.lowerQosToTheSubscriptionDesired(sub, publishingQos);
            this.publishToSession(duplicate, topic, sub, qos);
        }
    }

    private void publishToSession(ByteBuf payload, Topic topic, Subscription sub, MqttQoS qos) {
        boolean isSessionPresent;
        Session targetSession = this.sessionRegistry.retrieve(sub.getClientId());
        boolean bl = isSessionPresent = targetSession != null;
        if (isSessionPresent) {
            LOG.debug("Sending PUBLISH message to active subscriber CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
            targetSession.sendNotRetainedPublishOnSessionAtQos(topic, qos, payload);
        } else {
            LOG.debug("PUBLISH to not yet present session. CId: {}, topicFilter: {}, qos: {}", new Object[]{sub.getClientId(), sub.getTopicFilter(), qos});
        }
    }

    RoutingResults receivedPublishQos2(MQTTConnection connection, MqttPublishMessage msg, String username) {
        RoutingResults publishRoutings;
        LOG.trace("Processing PUB QoS2 message on connection: {}", (Object)connection);
        Topic topic = new Topic(msg.variableHeader().topicName());
        ByteBuf payload = msg.payload();
        String clientId = connection.getClientId();
        if (!this.authorizator.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client is not authorized to publish on topic: {}", (Object)topic);
            ReferenceCountUtil.release((Object)msg);
            return RoutingResults.preroutingError();
        }
        int messageID = msg.variableHeader().packetId();
        if (msg.fixedHeader().isDup()) {
            Set<String> failedClients = this.failedPublishes.listFailed(clientId, messageID);
            publishRoutings = this.publish2Subscribers(payload, topic, MqttQoS.EXACTLY_ONCE, failedClients);
        } else {
            publishRoutings = this.publish2Subscribers(payload, topic, MqttQoS.EXACTLY_ONCE);
        }
        if (publishRoutings.isAllSuccess()) {
            connection.sendPubRec(messageID);
            this.manageRetain(topic, msg);
            this.interceptor.notifyTopicPublished(msg, clientId, username);
        } else {
            this.failedPublishes.insertAll(messageID, clientId, publishRoutings.failedRoutings);
        }
        ReferenceCountUtil.release((Object)msg);
        this.failedPublishes.removeAll(messageID, clientId, publishRoutings.successedRoutings);
        return publishRoutings;
    }

    static MqttQoS lowerQosToTheSubscriptionDesired(Subscription sub, MqttQoS qos) {
        if (qos.value() > sub.getRequestedQos().value()) {
            qos = sub.getRequestedQos();
        }
        return qos;
    }

    public RoutingResults internalPublish(MqttPublishMessage msg) {
        MqttQoS qos = msg.fixedHeader().qosLevel();
        Topic topic = new Topic(msg.variableHeader().topicName());
        ByteBuf payload = msg.payload();
        LOG.info("Sending internal PUBLISH message Topic={}, qos={}", (Object)topic, (Object)qos);
        RoutingResults publishResult = this.publish2Subscribers(payload, topic, qos);
        LOG.trace("after routed publishes: {}", (Object)publishResult);
        if (!msg.fixedHeader().isRetain()) {
            return publishResult;
        }
        if (qos == MqttQoS.AT_MOST_ONCE || payload.readableBytes() == 0) {
            this.retainedRepository.cleanRetained(topic);
            return publishResult;
        }
        this.retainedRepository.retain(topic, msg);
        return publishResult;
    }

    void dispatchConnection(MqttConnectMessage msg) {
        this.interceptor.notifyClientConnected(msg);
    }

    void dispatchDisconnection(String clientId, String userName) {
        this.interceptor.notifyClientDisconnected(clientId, userName);
    }

    void dispatchConnectionLost(String clientId, String userName) {
        this.interceptor.notifyClientConnectionLost(clientId, userName);
    }

    String sessionLoopThreadName(String clientId) {
        return this.sessionLoops.sessionLoopThreadName(clientId);
    }

    public RouteResult routeCommand(String clientId, String actionDescription, Callable<String> action) {
        return this.sessionLoops.routeCommand(clientId, actionDescription, action);
    }

    public void terminate() {
        this.sessionLoops.terminate();
    }

    public void clientDisconnected(String clientID, String userName) {
        this.dispatchDisconnection(clientID, userName);
        this.failedPublishes.cleanupForClient(clientID);
    }

    private static class FailedPublishCollection {
        private final ConcurrentMap<PacketId, Set<String>> packetsMap = new ConcurrentHashMap<PacketId, Set<String>>();

        private FailedPublishCollection() {
        }

        private void insert(String clientId, int messageID, String failedClientId) {
            PacketId packetId = new PacketId(clientId, messageID);
            this.packetsMap.computeIfAbsent(packetId, k -> new HashSet()).add(failedClientId);
        }

        public void remove(String clientId, int messageID, String targetClientId) {
            PacketId packetId = new PacketId(clientId, messageID);
            this.packetsMap.computeIfPresent(packetId, (key, clientsSet) -> {
                clientsSet.remove(targetClientId);
                if (clientsSet.isEmpty()) {
                    return null;
                }
                return clientsSet;
            });
        }

        private void removeAll(int messageID, String clientId, Collection<String> routings) {
            for (String targetClientId : routings) {
                this.remove(clientId, messageID, targetClientId);
            }
        }

        void cleanupForClient(String clientId) {
            this.packetsMap.keySet().stream().filter(packet -> packet.belongToClient(clientId)).forEach(this.packetsMap::remove);
        }

        void insertAll(int messageID, String clientId, Collection<String> routings) {
            for (String targetClientId : routings) {
                this.insert(clientId, messageID, targetClientId);
            }
        }

        Set<String> listFailed(String clientId, int messageID) {
            PacketId packetId = new PacketId(clientId, messageID);
            return this.packetsMap.getOrDefault(packetId, Collections.emptySet());
        }

        static class PacketId {
            private final String clientId;
            private final int idPacket;

            PacketId(String clientId, int idPacket) {
                this.clientId = clientId;
                this.idPacket = idPacket;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PacketId packetId = (PacketId)o;
                return this.idPacket == packetId.idPacket && Objects.equals(this.clientId, packetId.clientId);
            }

            public int hashCode() {
                return Objects.hash(this.clientId, this.idPacket);
            }

            public boolean belongToClient(String clientId) {
                return this.clientId.equals(clientId);
            }
        }
    }

    private class BatchingPublishesCollector {
        final List<Subscription>[] subscriptions;
        private final int eventLoops;
        private final SessionEventLoopGroup loopGroup;

        BatchingPublishesCollector(SessionEventLoopGroup loopGroup) {
            this.eventLoops = loopGroup.getEventLoopCount();
            this.loopGroup = loopGroup;
            this.subscriptions = new List[this.eventLoops];
        }

        public void add(Subscription sub) {
            int targetQueueId = this.subscriberEventLoop(sub.getClientId());
            if (this.subscriptions[targetQueueId] == null) {
                this.subscriptions[targetQueueId] = new ArrayList<Subscription>();
            }
            this.subscriptions[targetQueueId].add(sub);
        }

        private int subscriberEventLoop(String clientId) {
            return this.loopGroup.targetQueueOrdinal(clientId);
        }

        List<RouteResult> routeBatchedPublishes(Consumer<List<Subscription>> action) {
            ArrayList<RouteResult> publishResults = new ArrayList<RouteResult>(this.eventLoops);
            for (List<Subscription> subscriptionsBatch : this.subscriptions) {
                if (subscriptionsBatch == null) continue;
                String clientId = subscriptionsBatch.get(0).getClientId();
                if (LOG.isTraceEnabled()) {
                    String subscriptionsDetails = subscriptionsBatch.stream().map(Subscription::toString).collect(Collectors.joining(",\n"));
                    int loopId = this.subscriberEventLoop(clientId);
                    LOG.trace("Routing PUBLISH to eventLoop {}  for subscriptions [{}]", (Object)loopId, (Object)subscriptionsDetails);
                }
                publishResults.add(PostOffice.this.routeCommand(clientId, "batched PUB", () -> {
                    action.accept(subscriptionsBatch);
                    return null;
                }));
            }
            return publishResults;
        }

        Collection<String> subscriberIdsByEventLoop(String clientId) {
            int targetQueueId = this.subscriberEventLoop(clientId);
            return this.subscriptions[targetQueueId].stream().map(Subscription::getClientId).collect(Collectors.toList());
        }

        public int countBatches() {
            int count = 0;
            for (List<Subscription> subscriptionsBatch : this.subscriptions) {
                if (subscriptionsBatch == null) continue;
                ++count;
            }
            return count;
        }
    }

    static class RouteResult {
        private final String clientId;
        private final Status status;
        private CompletableFuture queuedFuture;

        public static RouteResult success(String clientId, CompletableFuture queuedFuture) {
            return new RouteResult(clientId, Status.SUCCESS, queuedFuture);
        }

        public static RouteResult failed(String clientId) {
            return RouteResult.failed(clientId, null);
        }

        public static RouteResult failed(String clientId, String error) {
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(new Error(error));
            return new RouteResult(clientId, Status.FAIL, failed);
        }

        private RouteResult(String clientId, Status status, CompletableFuture queuedFuture) {
            this.clientId = clientId;
            this.status = status;
            this.queuedFuture = queuedFuture;
        }

        public CompletableFuture completableFuture() {
            if (this.status == Status.FAIL) {
                throw new IllegalArgumentException("Accessing completable future on a failed result");
            }
            return this.queuedFuture;
        }

        public boolean isSuccess() {
            return this.status == Status.SUCCESS;
        }

        public RouteResult ifFailed(Runnable action) {
            if (!this.isSuccess()) {
                action.run();
            }
            return this;
        }

        static enum Status {
            SUCCESS,
            FAIL;

        }
    }
}

