/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.MetricExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.PropagatorConfiguration;
import io.opentelemetry.sdk.autoconfigure.TracerProviderConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

@Deprecated
public final class OpenTelemetrySdkAutoConfiguration {
    @Deprecated
    public static OpenTelemetrySdk initialize() {
        return AutoConfiguredOpenTelemetrySdk.initialize().getOpenTelemetrySdk();
    }

    @Deprecated
    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal) {
        return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(setResultAsGlobal).build().getOpenTelemetrySdk();
    }

    @Deprecated
    public static OpenTelemetrySdk initialize(boolean setResultAsGlobal, ConfigProperties config) {
        return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(setResultAsGlobal).setConfig(config).build().getOpenTelemetrySdk();
    }

    static OpenTelemetrySdk newOpenTelemetrySdk(ConfigProperties config, Resource resource, ClassLoader serviceClassLoader, BiFunction<? super TextMapPropagator, ConfigProperties, ? extends TextMapPropagator> propagatorCustomizer, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer, boolean setResultAsGlobal) {
        ContextPropagators propagators = PropagatorConfiguration.configurePropagators(config, serviceClassLoader, propagatorCustomizer);
        OpenTelemetrySdkAutoConfiguration.configureMeterProvider(resource, config, serviceClassLoader);
        SdkTracerProvider tracerProvider = TracerProviderConfiguration.configureTracerProvider(resource, config, serviceClassLoader, spanExporterCustomizer, samplerCustomizer);
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).setPropagators(propagators).build();
        if (setResultAsGlobal) {
            GlobalOpenTelemetry.set((OpenTelemetry)openTelemetrySdk);
        }
        return openTelemetrySdk;
    }

    private static void configureMeterProvider(Resource resource, ConfigProperties config, ClassLoader serviceClassLoader) {
        SdkMeterProviderBuilder meterProviderBuilder = SdkMeterProvider.builder().setResource(resource);
        String exemplarFilter = config.getString("otel.metrics.exemplar.filter");
        if (exemplarFilter == null) {
            exemplarFilter = "with_sampled_trace";
        }
        switch (exemplarFilter) {
            case "none": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.neverSample());
                break;
            }
            case "all": {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.alwaysSample());
                break;
            }
            default: {
                meterProviderBuilder.setExemplarFilter(ExemplarFilter.sampleWithTraces());
            }
        }
        for (SdkMeterProviderConfigurer configurer : ServiceLoader.load(SdkMeterProviderConfigurer.class, serviceClassLoader)) {
            configurer.configure(meterProviderBuilder, config);
        }
        String exporterName = config.getString("otel.metrics.exporter");
        if (exporterName == null || exporterName.equals("none")) {
            GlobalMeterProvider.set((MeterProvider)MeterProvider.noop());
            return;
        }
        MetricExporterConfiguration.configureExporter(exporterName, config, serviceClassLoader, meterProviderBuilder);
        SdkMeterProvider meterProvider = meterProviderBuilder.buildAndRegisterGlobal();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)meterProvider).close()));
    }

    private OpenTelemetrySdkAutoConfiguration() {
    }
}

