/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.common;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.Message;

public class SpanJmsDecorator {
    public static void onRequest(Destination destination, Span span) {
        Tags.COMPONENT.set(span, "java-jms");
        Tags.MESSAGE_BUS_DESTINATION.set(span, destination.toString());
    }

    public static void onResponse(Message message, Span span) {
        Tags.COMPONENT.set(span, "java-jms");
    }

    public static void onError(Throwable throwable, Span span) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(SpanJmsDecorator.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("message", throwable.getMessage());
        errorLogs.put("error.object", throwable);
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

