/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jms.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.jms.spring.TracingJmsListenerConfigurer;
import io.opentracing.contrib.jms.spring.TracingJmsListenerEndpointRegistry;
import io.opentracing.contrib.jms.spring.TracingJmsTemplate;
import io.opentracing.contrib.jms.spring.TracingMessagingMessageListenerAdapter;
import javax.jms.ConnectionFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;

@Configuration
public class TracingJmsConfiguration {
    private final ObjectProvider<MessageConverter> messageConverter;

    public TracingJmsConfiguration(ObjectProvider<MessageConverter> messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Bean
    public TracingMessagingMessageListenerAdapter createTracingMessagingMessageListenerAdapter(Tracer tracer) {
        return new TracingMessagingMessageListenerAdapter(tracer);
    }

    @Bean
    public TracingJmsListenerEndpointRegistry createTracingJmsListenerEndpointRegistry(TracingMessagingMessageListenerAdapter listenerAdapter) {
        return new TracingJmsListenerEndpointRegistry(listenerAdapter);
    }

    @Bean
    public JmsListenerConfigurer createTracingJmsListenerConfigurer(TracingJmsListenerEndpointRegistry registry) {
        return new TracingJmsListenerConfigurer(registry);
    }

    @Bean
    public JmsTemplate jmsTemplate(BeanFactory beanFactory, Tracer tracer) {
        ConnectionFactory connectionFactory = this.createProxy(beanFactory);
        TracingJmsTemplate ret = new TracingJmsTemplate(connectionFactory, tracer);
        MessageConverter mc = (MessageConverter)this.messageConverter.getIfAvailable();
        if (mc != null) {
            ret.setMessageConverter(mc);
        }
        return ret;
    }

    private ConnectionFactory createProxy(final BeanFactory beanFactory) {
        return (ConnectionFactory)ProxyFactory.getProxy((TargetSource)new AbstractLazyCreationTargetSource(){

            public synchronized Class<?> getTargetClass() {
                return ConnectionFactory.class;
            }

            protected Object createObject() throws Exception {
                return beanFactory.getBean(ConnectionFactory.class);
            }
        });
    }
}

