/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.rabbitmq;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSendTracingHelper;
import io.opentracing.contrib.spring.rabbitmq.RabbitMqSpanDecorator;
import java.beans.ConstructorProperties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;

@Aspect
class RabbitMqSendTracingAspect {
    private final Tracer tracer;
    private final String exchange;
    private final String routingKey;
    private final MessageConverter messageConverter;
    private final RabbitMqSpanDecorator spanDecorator;

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.send(..)) && args(message)", argNames="pjp,message")
    public Object traceRabbitSend(ProceedingJoinPoint pjp, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.send(..)) && args(routingKey, message)", argNames="pjp,routingKey,message")
    public Object traceRabbitSend(ProceedingJoinPoint pjp, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.send(..)) && args(exchange, routingKey, message)", argNames="pjp,exchange, routingKey, message")
    public Object traceRabbitSend(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(message)", argNames="pjp,message")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(routingKey, message)", argNames="pjp,routingKey,message")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(exchange,routingKey, message)", argNames="pjp,exchange,routingKey,message")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(message, messagePostProcessor)", argNames="pjp,message,messagePostProcessor")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(routingKey, message, messagePostProcessor)", argNames="pjp,routingKey,message,messagePostProcessor")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertAndSend(..)) && args(exchange, routingKey, message, messagePostProcessor)", argNames="pjp,exchange,routingKey,message,messagePostProcessor")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.convertAndSend(..)) && args(routingKey, message, messagePostProcessor, correlationData)", argNames="pjp,routingKey,message,messagePostProcessor,correlationData")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.convertAndSend(..)) && args(exchange, routingKey, message, correlationData)", argNames="pjp,exchange,routingKey,message,correlationData")
    public Object traceRabbitConvertAndSend(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message, CorrelationData correlationData) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.sendAndReceive(..)) && args(message)", argNames="pjp,message")
    public Object traceRabbitSendAndReceive(ProceedingJoinPoint pjp, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.sendAndReceive(..)) && args(routingKey, message)", argNames="pjp,routingKey,message")
    public Object traceRabbitSendAndReceive(ProceedingJoinPoint pjp, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.sendAndReceive(..)) && args(exchange, routingKey, message)", argNames="pjp,exchange,routingKey,message")
    public Object traceRabbitSendAndReceive(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.sendAndReceive(..)) && args(exchange,routingKey, message, correlationData)", argNames="pjp,exchange,routingKey,message,correlationData")
    public Object traceRabbitSendAndReceive(ProceedingJoinPoint pjp, String exchange, String routingKey, Message message, CorrelationData correlationData) throws Throwable {
        return this.createTracingHelper().nullResponseMeansTimeout((RabbitTemplate)pjp.getTarget()).doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(message)", argNames="pjp,message")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(routingKey, message)", argNames="pjp,routingKey,message")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(exchange, routingKey, message)", argNames="pjp,exchange,routingKey,message")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(message, messagePostProcessor)", argNames="pjp,message,messagePostProcessor")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, this.routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 0));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(routingKey, message, messagePostProcessor)", argNames="pjp,routingKey,message,messagePostProcessor")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(this.exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 1));
    }

    @Around(value="execution(* org.springframework.amqp.core.AmqpTemplate.convertSendAndReceive(..)) && args(exchange, routingKey, message, messagePostProcessor)", argNames="pjp,exchange,routingKey,message,messagePostProcessor")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws Throwable {
        return this.createTracingHelper().doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    @Around(value="execution(* org.springframework.amqp.rabbit.core.RabbitTemplate.convertSendAndReceive(..)) && args(exchange, routingKey, message, messagePostProcessor, correlationData)", argNames="pjp,exchange,routingKey,message,messagePostProcessor,correlationData")
    public Object traceRabbitConvertSendAndReceive(ProceedingJoinPoint pjp, String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws Throwable {
        return this.createTracingHelper().nullResponseMeansTimeout((RabbitTemplate)pjp.getTarget()).doWithTracingHeadersMessage(exchange, routingKey, message, convertedMessage -> this.proceedReplacingMessage(pjp, convertedMessage, 2));
    }

    private RabbitMqSendTracingHelper createTracingHelper() {
        return new RabbitMqSendTracingHelper(this.tracer, this.messageConverter, this.spanDecorator);
    }

    private Object proceedReplacingMessage(ProceedingJoinPoint pjp, Message convertedMessage, int messageArgumentIndex) throws Throwable {
        Object[] args = pjp.getArgs();
        args[messageArgumentIndex] = convertedMessage;
        return pjp.proceed(args);
    }

    @ConstructorProperties(value={"tracer", "exchange", "routingKey", "messageConverter", "spanDecorator"})
    public RabbitMqSendTracingAspect(Tracer tracer, String exchange, String routingKey, MessageConverter messageConverter, RabbitMqSpanDecorator spanDecorator) {
        this.tracer = tracer;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.messageConverter = messageConverter;
        this.spanDecorator = spanDecorator;
    }
}

