/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.starter;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.client.RestTemplateSpanDecorator;
import io.opentracing.contrib.spring.web.client.TracingAsyncRestTemplateInterceptor;
import io.opentracing.contrib.spring.web.client.TracingRestTemplateInterceptor;
import io.opentracing.contrib.spring.web.starter.WebClientTracingProperties;
import io.opentracing.contrib.spring.web.starter.client.TracingRestTemplateCustomizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.support.InterceptingAsyncHttpAccessor;
import org.springframework.http.client.support.InterceptingHttpAccessor;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnProperty(prefix="opentracing.spring.web.client", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@EnableConfigurationProperties(value={WebClientTracingProperties.class})
public class RestTemplateTracingAutoConfiguration {
    private static final Log log = LogFactory.getLog(RestTemplateTracingAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={RestTemplateCustomizer.class})
    public static class TracingRestTemplateCustomizerConfiguration {
        private final Tracer tracer;
        private final List<RestTemplateSpanDecorator> spanDecorators;

        public TracingRestTemplateCustomizerConfiguration(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators) {
            this.tracer = tracer;
            this.spanDecorators = spanDecorators;
        }

        @Bean
        @ConditionalOnMissingBean(value={TracingRestTemplateCustomizer.class})
        public TracingRestTemplateCustomizer tracingRestTemplateCustomizer() {
            return new TracingRestTemplateCustomizer(this.tracer, this.spanDecorators);
        }
    }

    @Configuration
    @ConditionalOnBean(value={InterceptingAsyncHttpAccessor.class})
    @ConditionalOnClass(value={InterceptingAsyncHttpAccessor.class})
    public static class AsyncRestTemplatePostProcessingConfiguration {
        private final Tracer tracer;
        private final List<RestTemplateSpanDecorator> spanDecorators;
        private final Set<InterceptingAsyncHttpAccessor> restTemplates;

        public AsyncRestTemplatePostProcessingConfiguration(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators, Set<InterceptingAsyncHttpAccessor> restTemplates) {
            this.tracer = tracer;
            this.spanDecorators = spanDecorators;
            this.restTemplates = restTemplates;
        }

        @PostConstruct
        public void init() {
            for (InterceptingAsyncHttpAccessor restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }

        private void registerTracingInterceptor(InterceptingAsyncHttpAccessor restTemplate) {
            ArrayList<TracingAsyncRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
            for (AsyncClientHttpRequestInterceptor asyncClientHttpRequestInterceptor : interceptors) {
                if (!(asyncClientHttpRequestInterceptor instanceof TracingAsyncRestTemplateInterceptor)) continue;
                return;
            }
            log.debug((Object)("Adding " + TracingAsyncRestTemplateInterceptor.class.getSimpleName() + " to " + restTemplate));
            interceptors = new ArrayList<TracingAsyncRestTemplateInterceptor>(interceptors);
            interceptors.add(new TracingAsyncRestTemplateInterceptor(this.tracer, this.spanDecorators));
            restTemplate.setInterceptors(interceptors);
        }
    }

    @Configuration
    @ConditionalOnBean(value={InterceptingHttpAccessor.class})
    public static class RestTemplatePostProcessingConfiguration {
        private final Tracer tracer;
        private final List<RestTemplateSpanDecorator> spanDecorators;
        private final Set<InterceptingHttpAccessor> restTemplates;

        public RestTemplatePostProcessingConfiguration(Tracer tracer, List<RestTemplateSpanDecorator> spanDecorators, Set<InterceptingHttpAccessor> restTemplates) {
            this.tracer = tracer;
            this.spanDecorators = spanDecorators;
            this.restTemplates = restTemplates;
        }

        @PostConstruct
        public void init() {
            for (InterceptingHttpAccessor restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }

        private void registerTracingInterceptor(InterceptingHttpAccessor restTemplate) {
            ArrayList<TracingRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
            for (ClientHttpRequestInterceptor clientHttpRequestInterceptor : interceptors) {
                if (!(clientHttpRequestInterceptor instanceof TracingRestTemplateInterceptor)) continue;
                return;
            }
            log.debug((Object)("Adding " + TracingRestTemplateInterceptor.class.getSimpleName() + " to " + restTemplate));
            interceptors = new ArrayList<TracingRestTemplateInterceptor>(interceptors);
            interceptors.add(new TracingRestTemplateInterceptor(this.tracer, this.spanDecorators));
            restTemplate.setInterceptors(interceptors);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RestTemplateSpanDecorator.class})
    public static class StandardTagsConfiguration {
        @Bean
        public RestTemplateSpanDecorator.StandardTags standardTagsRestTemplateSpanDecorator() {
            return new RestTemplateSpanDecorator.StandardTags();
        }
    }
}

