/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.starter;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.starter.SkipPatternAutoConfiguration;
import io.opentracing.contrib.spring.web.starter.WebTracingProperties;
import io.opentracing.contrib.spring.web.webfilter.TracingWebFilter;
import io.opentracing.contrib.spring.web.webfilter.WebFluxSpanDecorator;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class, SkipPatternAutoConfiguration.class})
@EnableConfigurationProperties(value={WebTracingProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(name={"opentracing.spring.web.enabled"}, havingValue="true", matchIfMissing=true)
public class WebFluxTracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={TracingWebFilter.class})
    public TracingWebFilter traceFilter(Tracer tracer, WebTracingProperties webTracingProperties, ObjectProvider<List<WebFluxSpanDecorator>> webFilterSpanDecorators, @Qualifier(value="skipPattern") Pattern skipPattern) {
        return new TracingWebFilter(tracer, webTracingProperties.getOrder(), skipPattern, webTracingProperties.getUrlPatterns(), (List)webFilterSpanDecorators.getObject());
    }

    @ConditionalOnMissingBean(value={WebFluxSpanDecorator.class})
    @Configuration
    static class DefaultWebFluxSpanDecorators {
        DefaultWebFluxSpanDecorators() {
        }

        @Bean
        WebFluxSpanDecorator standardTagsWebFluxSpanDecorator() {
            return new WebFluxSpanDecorator.StandardTags();
        }

        @Bean
        WebFluxSpanDecorator webFluxTagsWebFluxSpanDecorator() {
            return new WebFluxSpanDecorator.WebFluxTags();
        }
    }
}

