/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.exporter;

import javax.xml.bind.DatatypeConverter;

public class Base64 {
    private static final boolean HAS_JAVA_UTIL_BASE64 = Base64.hasJavaUtilBase64();

    private static boolean hasJavaUtilBase64() {
        try {
            Class.forName("java.util.Base64");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Base64() {
    }

    public static String encodeToString(byte[] src) {
        if (src == null) {
            throw new NullPointerException();
        }
        if (HAS_JAVA_UTIL_BASE64) {
            return java.util.Base64.getEncoder().encodeToString(src);
        }
        return DatatypeConverter.printBase64Binary((byte[])src);
    }
}

