/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.compiler.parser;

import io.protostuff.compiler.parser.FileDescriptorLoader;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.Importer;
import io.protostuff.compiler.parser.ParserException;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ImporterImpl
implements Importer {
    private final FileDescriptorLoader loader;
    private Map<String, ProtoContext> cachedImports = new HashMap<String, ProtoContext>();

    @Inject
    public ImporterImpl(FileDescriptorLoader loader) {
        this.loader = loader;
    }

    @Override
    public ProtoContext importFile(FileReader reader, String fileName) {
        ProtoContext cachedInstance = this.cachedImports.get(fileName);
        if (cachedInstance != null) {
            if (cachedInstance.isInitialized()) {
                return cachedInstance;
            }
            throw new ParserException("Can not load proto: imports cycle found", new Object[0]);
        }
        ProtoContext context = this.loader.load(reader, fileName);
        this.cachedImports.put(fileName, context);
        return context;
    }
}

