/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.VertxOutput;
import io.quarkus.resteasy.runtime.standalone.VertxOutputStream;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class VertxHttpResponse
implements HttpResponse {
    private int status = 200;
    private OutputStream os;
    private MultivaluedMap<String, Object> outputHeaders;
    final HttpServerRequest request;
    final HttpServerResponse response;
    private boolean committed;
    private boolean finished;
    private ResteasyProviderFactory providerFactory;
    private final HttpMethod method;
    private final VertxOutput output;
    private final RoutingContext routingContext;

    public VertxHttpResponse(HttpServerRequest request, ResteasyProviderFactory providerFactory, HttpMethod method, BufferAllocator allocator, VertxOutput output, RoutingContext routingContext) {
        this.routingContext = routingContext;
        this.outputHeaders = new MultivaluedMapImpl();
        this.method = method;
        this.os = method == null || !method.equals((Object)HttpMethod.HEAD) ? new VertxOutputStream(this, allocator) : null;
        this.request = request;
        this.response = request.response();
        this.providerFactory = providerFactory;
        this.output = output;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    void checkException() throws IOException {
    }

    public void sendError(int status) throws IOException {
        this.checkException();
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkException();
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.response.setStatusCode(status);
        if (message != null) {
            this.response.end(message);
        } else {
            this.response.end();
        }
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        this.outputHeaders.clear();
    }

    public static void transformHeaders(VertxHttpResponse vertxResponse, HttpServerResponse response, ResteasyProviderFactory factory) {
        for (Map.Entry entry : vertxResponse.getOutputHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (Object value : (List)entry.getValue()) {
                if (value == null) {
                    response.headers().add(key, "");
                    continue;
                }
                RuntimeDelegate.HeaderDelegate delegate = factory.getHeaderDelegate(value.getClass());
                if (delegate != null) {
                    response.headers().add(key, delegate.toString(value));
                    continue;
                }
                response.headers().add(key, value.toString());
            }
        }
    }

    public void finish() throws IOException {
        this.checkException();
        if (this.finished || this.response.ended()) {
            return;
        }
        try {
            if (this.os != null) {
                this.os.close();
            } else {
                this.committed = true;
                this.response.setStatusCode(this.getStatus());
                VertxHttpResponse.transformHeaders(this, this.response, this.providerFactory);
                this.routingContext.addHeadersEndHandler(h -> {
                    this.response.headers().remove(HttpHeaders.CONTENT_LENGTH);
                    this.response.headers().set(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
                });
                this.response.end();
            }
        }
        finally {
            this.finished = true;
        }
    }

    public void flushBuffer() throws IOException {
        this.checkException();
        if (this.os != null) {
            this.os.flush();
        }
    }

    public void writeBlocking(ByteBuf buffer, boolean finished) throws IOException {
        this.checkException();
        this.prepareWrite(buffer, finished);
        this.output.write(buffer, finished);
    }

    public CompletionStage<Void> writeNonBlocking(ByteBuf buffer, boolean finished) {
        try {
            this.prepareWrite(buffer, finished);
        }
        catch (IOException e) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(e);
            return ret;
        }
        return this.output.writeNonBlocking(buffer, finished);
    }

    private void prepareWrite(ByteBuf buffer, boolean finished) throws IOException {
        if (!this.isCommitted()) {
            this.committed = true;
            this.response.setStatusCode(this.getStatus());
            if (finished) {
                if (buffer == null) {
                    this.getOutputHeaders().putSingle((Object)"Content-Length", (Object)"0");
                } else {
                    this.getOutputHeaders().putSingle((Object)"Content-Length", (Object)("" + buffer.readableBytes()));
                }
            } else {
                this.response.setChunked(true);
            }
            VertxHttpResponse.transformHeaders(this, this.response, this.providerFactory);
        }
        if (finished) {
            this.finished = true;
        }
    }
}

