/*
 * Decompiled with CFR 0.152.
 */
package io.seata.codec.seata.protocol.transaction;

import io.seata.codec.seata.protocol.transaction.AbstractTransactionResponseCodec;
import io.seata.core.model.BranchStatus;
import io.seata.core.protocol.transaction.AbstractBranchEndResponse;
import java.nio.ByteBuffer;

public abstract class AbstractBranchEndResponseCodec
extends AbstractTransactionResponseCodec {
    @Override
    public Class<?> getMessageClassType() {
        return AbstractBranchEndResponse.class;
    }

    @Override
    public <T> void encode(T t, ByteBuffer out) {
        super.encode(t, out);
        AbstractBranchEndResponse abstractBranchEndResponse = (AbstractBranchEndResponse)t;
        String xid = abstractBranchEndResponse.getXid();
        long branchId = abstractBranchEndResponse.getBranchId();
        BranchStatus branchStatus = abstractBranchEndResponse.getBranchStatus();
        if (xid != null) {
            byte[] bs = xid.getBytes(UTF8);
            out.putShort((short)bs.length);
            if (bs.length > 0) {
                out.put(bs);
            }
        } else {
            out.putShort((short)0);
        }
        out.putLong(branchId);
        out.put((byte)branchStatus.getCode());
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        super.decode(t, in);
        AbstractBranchEndResponse abstractBranchEndResponse = (AbstractBranchEndResponse)t;
        short xidLen = in.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            in.get(bs);
            abstractBranchEndResponse.setXid(new String(bs, UTF8));
        }
        abstractBranchEndResponse.setBranchId(in.getLong());
        abstractBranchEndResponse.setBranchStatus(BranchStatus.get(in.get()));
    }
}

