/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry.sofa;

import com.alipay.sofa.registry.client.api.RegistryClient;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.model.UserData;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClient;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfig;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfigBuilder;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import io.seata.common.util.NetUtil;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class SofaRegistryServiceImpl
implements RegistryService<SubscriberDataObserver> {
    private static final String SOFA_FILEKEY_PREFIX = "registry.sofa.";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String PRO_REGION_KEY = "region";
    private static final String PRO_DATACENTER_KEY = "datacenter";
    private static final String PRO_GROUP_KEY = "group";
    private static final String PRO_APPLICATION_KEY = "application";
    private static final String PRO_CLUSTER_KEY = "cluster";
    private static final String PRO_ADDRESS_WAIT_TIME_KEY = "addressWaitTime";
    private static final String DEFAULT_LOCAL_DATACENTER = "DefaultDataCenter";
    private static final String DEFAULT_LOCAL_REGION = "DEFAULT_ZONE";
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String DEFAULT_APPLICATION = "default";
    private static final String DEFAULT_CLUSTER = "default";
    private static final String DEFAULT_ADDRESS_WAIT_TIME = "3000";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final String HOST_SEPERATOR = ":";
    private static final String REGISTRY_TYPE = "sofa";
    private static final ConcurrentMap<String, List<SubscriberDataObserver>> LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<SubscriberDataObserver>>();
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
    private static Properties registryProps;
    private static volatile RegistryClient registryClient;
    private static volatile SofaRegistryServiceImpl instance;

    private SofaRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static SofaRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<SofaRegistryServiceImpl> clazz = SofaRegistryServiceImpl.class;
        synchronized (SofaRegistryServiceImpl.class) {
            if (null != instance) return instance;
            registryProps = SofaRegistryServiceImpl.getNamingProperties();
            instance = new SofaRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String clusterName = registryProps.getProperty(PRO_CLUSTER_KEY);
        PublisherRegistration publisherRegistration = new PublisherRegistration(clusterName);
        publisherRegistration.setGroup(registryProps.getProperty(PRO_GROUP_KEY));
        String serviceData = address.getAddress().getHostAddress() + HOST_SEPERATOR + address.getPort();
        this.getRegistryInstance().register(publisherRegistration, new String[]{serviceData});
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
        NetUtil.validAddress(address);
        String clusterName = registryProps.getProperty(PRO_CLUSTER_KEY);
        this.getRegistryInstance().unregister(clusterName, registryProps.getProperty(PRO_GROUP_KEY), RegistryType.PUBLISHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RegistryClient getRegistryInstance() {
        if (null != registryClient) return registryClient;
        Class<SofaRegistryServiceImpl> clazz = SofaRegistryServiceImpl.class;
        synchronized (SofaRegistryServiceImpl.class) {
            if (null != registryClient) return registryClient;
            String address = registryProps.getProperty(PRO_SERVER_ADDR_KEY);
            String portStr = StringUtils.substringAfter((String)address, (String)HOST_SEPERATOR);
            DefaultRegistryClientConfig config = DefaultRegistryClientConfigBuilder.start().setAppName(this.getApplicationName()).setDataCenter(registryProps.getProperty(PRO_DATACENTER_KEY)).setZone(registryProps.getProperty(PRO_REGION_KEY)).setRegistryEndpoint(StringUtils.substringBefore((String)address, (String)HOST_SEPERATOR)).setRegistryEndpointPort(Integer.parseInt(portStr)).build();
            registryClient = new DefaultRegistryClient((RegistryClientConfig)config);
            ((DefaultRegistryClient)registryClient).init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registryClient;
        }
    }

    @Override
    public void subscribe(String cluster, SubscriberDataObserver listener) throws Exception {
        SubscriberRegistration subscriberRegistration = new SubscriberRegistration(cluster, listener);
        subscriberRegistration.setScopeEnum(ScopeEnum.global);
        subscriberRegistration.setGroup(registryProps.getProperty(PRO_GROUP_KEY));
        LISTENER_SERVICE_MAP.putIfAbsent(cluster, new ArrayList());
        ((List)LISTENER_SERVICE_MAP.get(cluster)).add(listener);
        this.getRegistryInstance().register(subscriberRegistration);
    }

    @Override
    public void unsubscribe(String cluster, SubscriberDataObserver listener) throws Exception {
        this.getRegistryInstance().unregister(cluster, registryProps.getProperty(PRO_GROUP_KEY), RegistryType.SUBSCRIBER);
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        Configuration config = ConfigurationFactory.getInstance();
        final String clusterName = config.getConfig("service.vgroup_mapping." + key);
        if (null == clusterName) {
            return null;
        }
        if (!LISTENER_SERVICE_MAP.containsKey(clusterName)) {
            final CountDownLatch respondRegistries = new CountDownLatch(1);
            this.subscribe(clusterName, new SubscriberDataObserver(){

                public void handleData(String dataId, UserData data) {
                    Map instances = data.getZoneData();
                    if (null == instances && null != CLUSTER_ADDRESS_MAP.get(clusterName)) {
                        CLUSTER_ADDRESS_MAP.remove(clusterName);
                    } else {
                        List tranformData = SofaRegistryServiceImpl.this.flatData(instances);
                        ArrayList newAddressList = new ArrayList();
                        newAddressList.addAll(tranformData);
                        CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
                    }
                    respondRegistries.countDown();
                }
            });
            String property = registryProps.getProperty(PRO_ADDRESS_WAIT_TIME_KEY);
            respondRegistries.await(Integer.parseInt(property), TimeUnit.MILLISECONDS);
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterName);
    }

    private List<InetSocketAddress> flatData(Map<String, List<String>> instances) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>();
        for (Map.Entry<String, List<String>> entry : instances.entrySet()) {
            for (String str : entry.getValue()) {
                String ip = StringUtils.substringBefore((String)str, (String)HOST_SEPERATOR);
                String port = StringUtils.substringAfter((String)str, (String)HOST_SEPERATOR);
                InetSocketAddress inetSocketAddress = new InetSocketAddress(ip, Integer.parseInt(port));
                result.add(inetSocketAddress);
            }
        }
        return result;
    }

    @Override
    public void close() throws Exception {
    }

    private static Properties getNamingProperties() {
        String group;
        Properties properties = new Properties();
        if (null != System.getProperty("registry.sofa.serverAddr")) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaAddrFileKey());
            if (null != address) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (null != System.getProperty("registry.sofa.region")) {
            properties.setProperty(PRO_REGION_KEY, System.getProperty(PRO_REGION_KEY));
        } else {
            String region = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaRegionFileKey());
            if (null == region) {
                region = DEFAULT_LOCAL_REGION;
            }
            properties.setProperty(PRO_REGION_KEY, region);
        }
        if (null != System.getProperty("registry.sofa.datacenter")) {
            properties.setProperty(PRO_DATACENTER_KEY, System.getProperty(PRO_DATACENTER_KEY));
        } else {
            String datacenter = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaDataCenterFileKey());
            if (null == datacenter) {
                datacenter = DEFAULT_LOCAL_DATACENTER;
            }
            properties.setProperty(PRO_DATACENTER_KEY, datacenter);
        }
        if (null != System.getProperty("registry.sofa.group")) {
            properties.setProperty(PRO_GROUP_KEY, System.getProperty(PRO_GROUP_KEY));
        } else {
            group = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaGroupFileKey());
            if (null == group) {
                group = DEFAULT_GROUP;
            }
            properties.setProperty(PRO_GROUP_KEY, group);
        }
        if (null != System.getProperty("registry.sofa.cluster")) {
            properties.setProperty(PRO_CLUSTER_KEY, System.getProperty(PRO_CLUSTER_KEY));
        } else {
            String cluster = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaClusterFileKey());
            if (null == cluster) {
                cluster = "default";
            }
            properties.setProperty(PRO_CLUSTER_KEY, cluster);
        }
        if (null != System.getProperty("registry.sofa.addressWaitTime")) {
            properties.setProperty(PRO_ADDRESS_WAIT_TIME_KEY, System.getProperty(PRO_ADDRESS_WAIT_TIME_KEY));
        } else {
            group = FILE_CONFIG.getConfig(SofaRegistryServiceImpl.getSofaAddressWaitTimeFileKey());
            if (null == group) {
                group = DEFAULT_ADDRESS_WAIT_TIME;
            }
            properties.setProperty(PRO_ADDRESS_WAIT_TIME_KEY, group);
        }
        return properties;
    }

    private static String getSofaClusterFileKey() {
        return "registry.sofa.cluster";
    }

    private static String getSofaAddressWaitTimeFileKey() {
        return "registry.sofa.addressWaitTime";
    }

    private static String getSofaAddrFileKey() {
        return "registry.sofa.serverAddr";
    }

    private static String getSofaRegionFileKey() {
        return "registry.sofa.region";
    }

    private static String getSofaDataCenterFileKey() {
        return "registry.sofa.datacenter";
    }

    private static String getSofaGroupFileKey() {
        return "registry.sofa.group";
    }

    private String getApplicationFileKey() {
        return "registry.sofa.application";
    }

    private String getApplicationName() {
        String application = FILE_CONFIG.getConfig(this.getApplicationFileKey());
        if (null == application) {
            application = "default";
        }
        return application;
    }
}

