/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource;

import io.seata.rm.datasource.AbstractConnectionProxy;
import io.seata.rm.datasource.AbstractPreparedStatementProxy;
import io.seata.rm.datasource.ParametersHolder;
import io.seata.rm.datasource.exec.ExecuteTemplate;
import io.seata.rm.datasource.exec.StatementCallback;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreparedStatementProxy
extends AbstractPreparedStatementProxy
implements PreparedStatement,
ParametersHolder {
    @Override
    public ArrayList<Object>[] getParameters() {
        return this.parameters;
    }

    private void init() throws SQLException {
        int paramCount = ((PreparedStatement)this.targetStatement).getParameterMetaData().getParameterCount();
        this.parameters = new ArrayList[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.parameters[i] = new ArrayList();
        }
    }

    public PreparedStatementProxy(AbstractConnectionProxy connectionProxy, PreparedStatement targetStatement, String targetSQL) throws SQLException {
        super(connectionProxy, targetStatement, targetSQL);
        this.init();
    }

    @Override
    public boolean execute() throws SQLException {
        return ExecuteTemplate.execute(this, new StatementCallback<Boolean, PreparedStatement>(){

            @Override
            public Boolean execute(PreparedStatement statement, Object ... args) throws SQLException {
                return statement.execute();
            }
        }, new Object[0]);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return ExecuteTemplate.execute(this, new StatementCallback<ResultSet, PreparedStatement>(){

            @Override
            public ResultSet execute(PreparedStatement statement, Object ... args) throws SQLException {
                return statement.executeQuery();
            }
        }, new Object[0]);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return ExecuteTemplate.execute(this, new StatementCallback<Integer, PreparedStatement>(){

            @Override
            public Integer execute(PreparedStatement statement, Object ... args) throws SQLException {
                return statement.executeUpdate();
            }
        }, new Object[0]);
    }
}

