/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.rm.datasource.undo.UndoLogConstants;
import io.seata.rm.datasource.undo.UndoLogParser;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UndoLogParserFactory {
    private static final ConcurrentMap<String, UndoLogParser> INSTANCES = new ConcurrentHashMap<String, UndoLogParser>();

    public static UndoLogParser getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UndoLogParser getInstance(String name) {
        UndoLogParser parser = (UndoLogParser)INSTANCES.get(name);
        if (parser != null) return parser;
        Class<UndoLogParserFactory> clazz = UndoLogParserFactory.class;
        synchronized (UndoLogParserFactory.class) {
            parser = (UndoLogParser)INSTANCES.get(name);
            if (parser != null) return parser;
            parser = EnhancedServiceLoader.load(UndoLogParser.class, name);
            INSTANCES.putIfAbsent(name, parser);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return parser;
        }
    }

    private static class SingletonHolder {
        private static final UndoLogParser INSTANCE = UndoLogParserFactory.getInstance(UndoLogConstants.DEFAULT_SERIALIZER);

        private SingletonHolder() {
        }
    }
}

