/*
 * Decompiled with CFR 0.152.
 */
package io.seata.tm.api.transaction;

import io.seata.tm.api.transaction.TransactionHook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransactionHookManager {
    private static final ThreadLocal<List<TransactionHook>> LOCAL_HOOKS = new ThreadLocal();

    public static List<TransactionHook> getHooks() throws IllegalStateException {
        List<TransactionHook> hooks = LOCAL_HOOKS.get();
        if (hooks == null || hooks.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(hooks);
    }

    public static void registerHook(TransactionHook transactionHook) {
        if (transactionHook == null) {
            throw new NullPointerException("transactionHook must not be null");
        }
        List<TransactionHook> transactionHooks = LOCAL_HOOKS.get();
        if (transactionHooks == null) {
            LOCAL_HOOKS.set(new ArrayList());
        }
        LOCAL_HOOKS.get().add(transactionHook);
    }

    public static void clear() {
        LOCAL_HOOKS.remove();
    }
}

