/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.common.util.StringUtils;
import io.seata.config.ConfigChangeListener;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryService;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class FileRegistryServiceImpl
implements RegistryService<ConfigChangeListener> {
    private static volatile FileRegistryServiceImpl instance;
    private static final Configuration CONFIG;
    private static final String POSTFIX_GROUPLIST = ".grouplist";
    private static final String ENDPOINT_SPLIT_CHAR = ";";
    private static final String IP_PORT_SPLIT_CHAR = ":";

    private FileRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FileRegistryServiceImpl getInstance() {
        if (null != instance) return instance;
        Class<FileRegistryServiceImpl> clazz = FileRegistryServiceImpl.class;
        synchronized (FileRegistryServiceImpl.class) {
            if (null != instance) return instance;
            instance = new FileRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(InetSocketAddress address) throws Exception {
    }

    @Override
    public void unregister(InetSocketAddress address) throws Exception {
    }

    @Override
    public void subscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    @Override
    public void unsubscribe(String cluster, ConfigChangeListener listener) throws Exception {
    }

    @Override
    public List<InetSocketAddress> lookup(String key) throws Exception {
        String clusterName = this.getServiceGroup(key);
        if (null == clusterName) {
            return null;
        }
        String endpointStr = CONFIG.getConfig("service." + clusterName + POSTFIX_GROUPLIST);
        if (StringUtils.isNullOrEmpty(endpointStr)) {
            throw new IllegalArgumentException(clusterName + POSTFIX_GROUPLIST + " is required");
        }
        String[] endpoints = endpointStr.split(ENDPOINT_SPLIT_CHAR);
        ArrayList<InetSocketAddress> inetSocketAddresses = new ArrayList<InetSocketAddress>();
        for (String endpoint : endpoints) {
            String[] ipAndPort = endpoint.split(IP_PORT_SPLIT_CHAR);
            if (ipAndPort.length != 2) {
                throw new IllegalArgumentException("endpoint format should like ip:port");
            }
            inetSocketAddresses.add(new InetSocketAddress(ipAndPort[0], Integer.parseInt(ipAndPort[1])));
        }
        return inetSocketAddresses;
    }

    @Override
    public void close() throws Exception {
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

