/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.seata.protocol.transaction;

import io.netty.buffer.ByteBuf;
import io.seata.core.model.BranchType;
import io.seata.core.protocol.transaction.AbstractBranchEndRequest;
import io.seata.serializer.seata.protocol.transaction.AbstractTransactionRequestToRMCodec;
import java.nio.ByteBuffer;

public abstract class AbstractBranchEndRequestCodec
extends AbstractTransactionRequestToRMCodec {
    @Override
    public Class<?> getMessageClassType() {
        return AbstractBranchEndRequest.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        byte[] bs;
        AbstractBranchEndRequest abstractBranchEndRequest = (AbstractBranchEndRequest)t;
        String xid = abstractBranchEndRequest.getXid();
        long branchId = abstractBranchEndRequest.getBranchId();
        BranchType branchType = abstractBranchEndRequest.getBranchType();
        String resourceId = abstractBranchEndRequest.getResourceId();
        String applicationData = abstractBranchEndRequest.getApplicationData();
        if (xid != null) {
            bs = xid.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        out.writeLong(branchId);
        out.writeByte(branchType.ordinal());
        if (resourceId != null) {
            bs = resourceId.getBytes(UTF8);
            out.writeShort((int)((short)bs.length));
            if (bs.length > 0) {
                out.writeBytes(bs);
            }
        } else {
            out.writeShort(0);
        }
        byte[] applicationDataBytes = null;
        if (applicationData != null) {
            applicationDataBytes = applicationData.getBytes(UTF8);
            out.writeInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                out.writeBytes(applicationDataBytes);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        AbstractBranchEndRequest abstractBranchEndRequest = (AbstractBranchEndRequest)t;
        int xidLen = 0;
        if (in.remaining() >= 2) {
            xidLen = in.getShort();
        }
        if (xidLen <= 0) {
            return;
        }
        if (in.remaining() < xidLen) {
            return;
        }
        byte[] bs = new byte[xidLen];
        in.get(bs);
        abstractBranchEndRequest.setXid(new String(bs, UTF8));
        if (in.remaining() < 8) {
            return;
        }
        abstractBranchEndRequest.setBranchId(in.getLong());
        if (in.remaining() < 1) {
            return;
        }
        abstractBranchEndRequest.setBranchType(BranchType.get(in.get()));
        short resourceIdLen = 0;
        if (in.remaining() < 2) {
            return;
        }
        resourceIdLen = in.getShort();
        if (resourceIdLen <= 0) {
            return;
        }
        if (in.remaining() < resourceIdLen) {
            return;
        }
        bs = new byte[resourceIdLen];
        in.get(bs);
        abstractBranchEndRequest.setResourceId(new String(bs, UTF8));
        int applicationDataLen = 0;
        if (in.remaining() < 4) {
            return;
        }
        applicationDataLen = in.getInt();
        if (applicationDataLen > 0) {
            if (in.remaining() < applicationDataLen) {
                return;
            }
            bs = new byte[applicationDataLen];
            in.get(bs);
            abstractBranchEndRequest.setApplicationData(new String(bs, UTF8));
        }
    }
}

