/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.druid;

import io.seata.common.loader.LoadLevel;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLRecognizerFactory;
import io.seata.sqlparser.druid.DruidIsolationClassLoader;
import java.lang.reflect.Constructor;
import java.util.List;

@LoadLevel(name="druid")
public class DruidDelegatingSQLRecognizerFactory
implements SQLRecognizerFactory {
    private volatile SQLRecognizerFactory recognizerFactoryImpl;

    public DruidDelegatingSQLRecognizerFactory() {
        this.setClassLoader(DruidIsolationClassLoader.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setClassLoader(ClassLoader classLoader) {
        try {
            Class<?> recognizerFactoryImplClass = classLoader.loadClass("io.seata.sqlparser.druid.DruidSQLRecognizerFactoryImpl");
            Constructor<?> implConstructor = recognizerFactoryImplClass.getDeclaredConstructor(new Class[0]);
            implConstructor.setAccessible(true);
            try {
                this.recognizerFactoryImpl = (SQLRecognizerFactory)implConstructor.newInstance(new Object[0]);
            }
            finally {
                implConstructor.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new SQLParsingException(e);
        }
    }

    @Override
    public List<SQLRecognizer> create(String sql, String dbType) {
        return this.recognizerFactoryImpl.create(sql, dbType);
    }
}

