/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo.oracle;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.CollectionUtils;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.sql.struct.Field;
import io.seata.rm.datasource.sql.struct.Row;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.rm.datasource.undo.AbstractUndoExecutor;
import io.seata.rm.datasource.undo.SQLUndoLog;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OracleUndoInsertExecutor
extends AbstractUndoExecutor {
    private static final String DELETE_SQL_TEMPLATE = "DELETE FROM %s WHERE %s ";

    @Override
    protected String buildUndoSQL() {
        TableRecords afterImage = this.sqlUndoLog.getAfterImage();
        List<Row> afterImageRows = afterImage.getRows();
        if (CollectionUtils.isEmpty(afterImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        return this.generateDeleteSql(afterImageRows, afterImage);
    }

    @Override
    protected void undoPrepare(PreparedStatement undoPST, ArrayList<Field> undoValues, List<Field> pkValueList) throws SQLException {
        int undoIndex = 0;
        for (Field pkField : pkValueList) {
            undoPST.setObject(++undoIndex, pkField.getValue(), pkField.getType());
        }
    }

    private String generateDeleteSql(List<Row> rows, TableRecords afterImage) {
        List<String> pkNameList = this.getOrderedPkList(afterImage, rows.get(0), "oracle").stream().map(e -> e.getName()).collect(Collectors.toList());
        String whereSql = SqlGenerateUtils.buildWhereConditionByPKs(pkNameList, "oracle");
        return String.format(DELETE_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), whereSql);
    }

    public OracleUndoInsertExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getAfterImage();
    }
}

