/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.xa;

import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.xa.AbstractConnectionProxyXA;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTemplateXA {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteTemplateXA.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, S extends Statement> T execute(AbstractConnectionProxyXA connectionProxyXA, StatementCallback<T, S> statementCallback, S targetStatement, Object ... args) throws SQLException {
        boolean autoCommitStatus = connectionProxyXA.getAutoCommit();
        if (autoCommitStatus) {
            connectionProxyXA.setAutoCommit(false);
        }
        try {
            T res = null;
            try {
                res = statementCallback.execute(targetStatement, args);
            }
            catch (Throwable ex) {
                if (autoCommitStatus) {
                    try {
                        connectionProxyXA.rollback();
                    }
                    catch (SQLException sqle) {
                        LOGGER.warn("Failed to rollback xa branch of " + connectionProxyXA.xid + "(caused by SQL execution failure(" + ex.getMessage() + ") since " + sqle.getMessage(), (Throwable)sqle);
                    }
                }
                if (ex instanceof SQLException) {
                    throw ex;
                }
                throw new SQLException(ex);
            }
            if (autoCommitStatus) {
                try {
                    connectionProxyXA.commit();
                }
                catch (Throwable ex) {
                    LOGGER.warn("Failed to commit xa branch of " + connectionProxyXA.xid + ") since " + ex.getMessage(), ex);
                    if (!(ex instanceof SQLException) || !"SQLSTATE_XA_NOT_END".equalsIgnoreCase(((SQLException)ex).getSQLState())) {
                        try {
                            connectionProxyXA.rollback();
                        }
                        catch (SQLException sqle) {
                            LOGGER.warn("Failed to rollback xa branch of " + connectionProxyXA.xid + "(caused by commit failure(" + ex.getMessage() + ") since " + sqle.getMessage(), (Throwable)sqle);
                        }
                    }
                    if (ex instanceof SQLException) {
                        throw ex;
                    }
                    throw new SQLException(ex);
                }
            }
            T t = res;
            return t;
        }
        finally {
            if (autoCommitStatus) {
                connectionProxyXA.setAutoCommit(true);
            }
        }
    }
}

