/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.expression;

import io.seata.common.util.StringUtils;
import io.seata.saga.engine.expression.ExpressionFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExpressionFactoryManager {
    public static final String DEFAULT_EXPRESSION_TYPE = "Default";
    private Map<String, ExpressionFactory> expressionFactoryMap = new ConcurrentHashMap<String, ExpressionFactory>();

    public ExpressionFactory getExpressionFactory(String expressionType) {
        if (StringUtils.isBlank(expressionType)) {
            expressionType = DEFAULT_EXPRESSION_TYPE;
        }
        return this.expressionFactoryMap.get(expressionType);
    }

    public void setExpressionFactoryMap(Map<String, ExpressionFactory> expressionFactoryMap) {
        this.expressionFactoryMap.putAll(expressionFactoryMap);
    }

    public void putExpressionFactory(String type, ExpressionFactory factory) {
        this.expressionFactoryMap.put(type, factory);
    }
}

