/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec.oracle;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseInsertExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.struct.Null;
import io.seata.sqlparser.struct.Sequenceable;
import io.seata.sqlparser.struct.SqlMethodExpr;
import io.seata.sqlparser.struct.SqlSequenceExpr;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="oracle", scope=Scope.PROTOTYPE)
public class OracleInsertExecutor
extends BaseInsertExecutor
implements Sequenceable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleInsertExecutor.class);

    public OracleInsertExecutor(StatementProxy statementProxy, StatementCallback statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    @Override
    public Map<String, List<Object>> getPkValues() throws SQLException {
        Map<String, List<Object>> pkValuesMap = null;
        boolean isContainsPk = this.containsPK();
        if (isContainsPk) {
            pkValuesMap = this.getPkValuesByColumn();
        } else if (this.containsColumns()) {
            String columnName = this.getTableMeta().getPrimaryKeyOnlyName().get(0);
            pkValuesMap = Collections.singletonMap(columnName, this.getGeneratedKeys());
        } else {
            pkValuesMap = this.getPkValuesByColumn();
        }
        return pkValuesMap;
    }

    @Override
    public Map<String, List<Object>> getPkValuesByColumn() throws SQLException {
        String pkKey;
        Map<String, List<Object>> pkValuesMap = this.parsePkValuesFromStatement();
        List<Object> pkValues = pkValuesMap.get(pkKey = pkValuesMap.keySet().iterator().next());
        if (!pkValues.isEmpty() && pkValues.get(0) instanceof SqlSequenceExpr) {
            pkValuesMap.put(pkKey, this.getPkValuesBySequence((SqlSequenceExpr)pkValues.get(0)));
        } else if (pkValues.size() == 1 && pkValues.get(0) instanceof SqlMethodExpr) {
            pkValuesMap.put(pkKey, this.getGeneratedKeys());
        } else if (pkValues.size() == 1 && pkValues.get(0) instanceof Null) {
            throw new NotSupportYetException("oracle not support null");
        }
        return pkValuesMap;
    }

    public String getSequenceSql(SqlSequenceExpr expr) {
        return "SELECT " + expr.getSequence() + ".currval FROM DUAL";
    }
}

