/*
 * Decompiled with CFR 0.152.
 */
package io.seata.serializer.seata.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.BatchResultMessage;
import io.seata.serializer.seata.MessageCodecFactory;
import io.seata.serializer.seata.MessageSeataCodec;
import io.seata.serializer.seata.protocol.AbstractMessageCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BatchResultMessageCodec
extends AbstractMessageCodec {
    @Override
    public Class<?> getMessageClassType() {
        return BatchResultMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        BatchResultMessage batchResultMessage = (BatchResultMessage)t;
        List msgs = batchResultMessage.getResultMessages();
        List msgIds = batchResultMessage.getMsgIds();
        ByteBuf buffer = Unpooled.buffer((int)1024);
        buffer.writeInt(0);
        buffer.writeShort((int)((short)msgs.size()));
        for (AbstractMessage msg : msgs) {
            ByteBuf subBuffer = Unpooled.buffer((int)1024);
            short typeCode = msg.getTypeCode();
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.encode(msg, subBuffer);
            buffer.writeShort((int)msg.getTypeCode());
            buffer.writeBytes(subBuffer);
        }
        for (Integer msgId : msgIds) {
            buffer.writeInt(msgId.intValue());
        }
        int length = buffer.readableBytes();
        byte[] content = new byte[length];
        buffer.setInt(0, length - 4);
        buffer.readBytes(content);
        if (msgs.size() > 20 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("msg in one packet:" + msgs.size() + ",buffer size:" + content.length);
        }
        out.writeBytes(content);
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        BatchResultMessage batchResultMessage = (BatchResultMessage)t;
        if (in.remaining() < 4) {
            return;
        }
        int length = in.getInt();
        if (in.remaining() < length) {
            return;
        }
        byte[] buffer = new byte[length];
        in.get(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(batchResultMessage, byteBuffer);
    }

    protected void decode(BatchResultMessage batchResultMessage, ByteBuffer byteBuffer) {
        int idx;
        int msgNum = byteBuffer.getShort();
        ArrayList<AbstractResultMessage> msgs = new ArrayList<AbstractResultMessage>();
        ArrayList<Integer> msgIds = new ArrayList<Integer>();
        for (idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            AbstractMessage abstractResultMessage = MessageCodecFactory.getMessage(typeCode);
            MessageSeataCodec messageCodec = MessageCodecFactory.getMessageCodec(typeCode);
            messageCodec.decode(abstractResultMessage, byteBuffer);
            msgs.add((AbstractResultMessage)abstractResultMessage);
        }
        for (idx = 0; idx < msgNum; ++idx) {
            msgIds.add(byteBuffer.getInt());
        }
        batchResultMessage.setResultMessages(msgs);
        batchResultMessage.setMsgIds(msgIds);
    }
}

