/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import io.seata.common.exception.StoreException;
import io.seata.core.exception.AbstractExceptionHandler;
import io.seata.core.exception.TransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.model.GlobalStatus;
import io.seata.core.protocol.transaction.AbstractGlobalEndRequest;
import io.seata.core.protocol.transaction.AbstractGlobalEndResponse;
import io.seata.core.protocol.transaction.AbstractTransactionRequest;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import io.seata.core.protocol.transaction.BranchRegisterResponse;
import io.seata.core.protocol.transaction.BranchReportRequest;
import io.seata.core.protocol.transaction.BranchReportResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalLockQueryRequest;
import io.seata.core.protocol.transaction.GlobalLockQueryResponse;
import io.seata.core.protocol.transaction.GlobalReportRequest;
import io.seata.core.protocol.transaction.GlobalReportResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import io.seata.core.protocol.transaction.TCInboundHandler;
import io.seata.core.rpc.RpcContext;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTCInboundHandler
extends AbstractExceptionHandler
implements TCInboundHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTCInboundHandler.class);

    public GlobalBeginResponse handle(GlobalBeginRequest request, final RpcContext rpcContext) {
        GlobalBeginResponse response = new GlobalBeginResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalBeginRequest, GlobalBeginResponse>(){

            public void execute(GlobalBeginRequest request, GlobalBeginResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doGlobalBegin(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("begin global request failed. xid=%s, msg=%s", response.getXid(), e.getMessage()), (Throwable)e);
                }
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalBegin(GlobalBeginRequest var1, GlobalBeginResponse var2, RpcContext var3) throws TransactionException;

    public GlobalCommitResponse handle(GlobalCommitRequest request, final RpcContext rpcContext) {
        GlobalCommitResponse response = new GlobalCommitResponse();
        response.setGlobalStatus(GlobalStatus.Committing);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalCommitRequest, GlobalCommitResponse>(){

            public void execute(GlobalCommitRequest request, GlobalCommitResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doGlobalCommit(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("global commit request failed. xid=%s, msg=%s", request.getXid(), e.getMessage()), (Throwable)e);
                }
            }

            public void onTransactionException(GlobalCommitRequest request, GlobalCommitResponse response, TransactionException tex) {
                super.onTransactionException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, tex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }

            public void onException(GlobalCommitRequest request, GlobalCommitResponse response, Exception rex) {
                super.onException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, rex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalCommit(GlobalCommitRequest var1, GlobalCommitResponse var2, RpcContext var3) throws TransactionException;

    public GlobalRollbackResponse handle(GlobalRollbackRequest request, final RpcContext rpcContext) {
        GlobalRollbackResponse response = new GlobalRollbackResponse();
        response.setGlobalStatus(GlobalStatus.Rollbacking);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalRollbackRequest, GlobalRollbackResponse>(){

            public void execute(GlobalRollbackRequest request, GlobalRollbackResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doGlobalRollback(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("global rollback request failed. xid=%s, msg=%s", request.getXid(), e.getMessage()), (Throwable)e);
                }
            }

            public void onTransactionException(GlobalRollbackRequest request, GlobalRollbackResponse response, TransactionException tex) {
                super.onTransactionException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, tex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }

            public void onException(GlobalRollbackRequest request, GlobalRollbackResponse response, Exception rex) {
                super.onException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, rex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalRollback(GlobalRollbackRequest var1, GlobalRollbackResponse var2, RpcContext var3) throws TransactionException;

    public BranchRegisterResponse handle(BranchRegisterRequest request, final RpcContext rpcContext) {
        BranchRegisterResponse response = new BranchRegisterResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<BranchRegisterRequest, BranchRegisterResponse>(){

            public void execute(BranchRegisterRequest request, BranchRegisterResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doBranchRegister(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("branch register request failed. xid=%s, msg=%s", request.getXid(), e.getMessage()), (Throwable)e);
                }
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doBranchRegister(BranchRegisterRequest var1, BranchRegisterResponse var2, RpcContext var3) throws TransactionException;

    public BranchReportResponse handle(BranchReportRequest request, final RpcContext rpcContext) {
        BranchReportResponse response = new BranchReportResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<BranchReportRequest, BranchReportResponse>(){

            public void execute(BranchReportRequest request, BranchReportResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doBranchReport(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("branch report request failed. xid=%s, branchId=%s, msg=%s", request.getXid(), request.getBranchId(), e.getMessage()), (Throwable)e);
                }
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doBranchReport(BranchReportRequest var1, BranchReportResponse var2, RpcContext var3) throws TransactionException;

    public GlobalLockQueryResponse handle(GlobalLockQueryRequest request, final RpcContext rpcContext) {
        GlobalLockQueryResponse response = new GlobalLockQueryResponse();
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalLockQueryRequest, GlobalLockQueryResponse>(){

            public void execute(GlobalLockQueryRequest request, GlobalLockQueryResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doLockCheck(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("global lock query request failed. xid=%s, msg=%s", request.getXid(), e.getMessage()), (Throwable)e);
                }
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doLockCheck(GlobalLockQueryRequest var1, GlobalLockQueryResponse var2, RpcContext var3) throws TransactionException;

    public GlobalStatusResponse handle(GlobalStatusRequest request, final RpcContext rpcContext) {
        GlobalStatusResponse response = new GlobalStatusResponse();
        response.setGlobalStatus(GlobalStatus.UnKnown);
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalStatusRequest, GlobalStatusResponse>(){

            public void execute(GlobalStatusRequest request, GlobalStatusResponse response) throws TransactionException {
                try {
                    AbstractTCInboundHandler.this.doGlobalStatus(request, response, rpcContext);
                }
                catch (StoreException e) {
                    throw new TransactionException(TransactionExceptionCode.FailedStore, String.format("global status request failed. xid=%s, msg=%s", request.getXid(), e.getMessage()), (Throwable)e);
                }
            }

            public void onTransactionException(GlobalStatusRequest request, GlobalStatusResponse response, TransactionException tex) {
                super.onTransactionException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, tex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }

            public void onException(GlobalStatusRequest request, GlobalStatusResponse response, Exception rex) {
                super.onException((AbstractTransactionRequest)request, (AbstractTransactionResponse)response, rex);
                AbstractTCInboundHandler.this.checkTransactionStatus((AbstractGlobalEndRequest)request, (AbstractGlobalEndResponse)response);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalStatus(GlobalStatusRequest var1, GlobalStatusResponse var2, RpcContext var3) throws TransactionException;

    public GlobalReportResponse handle(GlobalReportRequest request, final RpcContext rpcContext) {
        GlobalReportResponse response = new GlobalReportResponse();
        response.setGlobalStatus(request.getGlobalStatus());
        this.exceptionHandleTemplate((AbstractExceptionHandler.Callback)new AbstractExceptionHandler.AbstractCallback<GlobalReportRequest, GlobalReportResponse>(){

            public void execute(GlobalReportRequest request, GlobalReportResponse response) throws TransactionException {
                AbstractTCInboundHandler.this.doGlobalReport(request, response, rpcContext);
            }
        }, (AbstractTransactionRequest)request, (AbstractTransactionResponse)response);
        return response;
    }

    protected abstract void doGlobalReport(GlobalReportRequest var1, GlobalReportResponse var2, RpcContext var3) throws TransactionException;

    private void checkTransactionStatus(AbstractGlobalEndRequest request, AbstractGlobalEndResponse response) {
        try {
            GlobalSession globalSession = SessionHolder.findGlobalSession(request.getXid(), false);
            if (globalSession != null) {
                response.setGlobalStatus(globalSession.getStatus());
            } else {
                response.setGlobalStatus(GlobalStatus.Finished);
            }
        }
        catch (Exception exx) {
            LOGGER.error("check transaction status error,{}]", (Object)exx.getMessage());
        }
    }
}

