/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.server.env.ContainerHelper;

public class ParameterParser {
    private static final String PROGRAM_NAME = "sh seata-server.sh(for linux and mac) or cmd seata-server.bat(for windows)";
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"--host", "-h"}, description="The ip to register to registry center.", order=1)
    private String host;
    @Parameter(names={"--port", "-p"}, description="The port to listen.", order=2)
    private int port = 8091;
    @Parameter(names={"--storeMode", "-m"}, description="log store mode : file, db", order=3)
    private String storeMode;
    @Parameter(names={"--serverNode", "-n"}, description="server node id, such as 1, 2, 3.it will be generated according to the snowflake by default", order=4)
    private Long serverNode;
    @Parameter(names={"--seataEnv", "-e"}, description="The name used for multi-configuration isolation.", order=5)
    private String seataEnv;

    public ParameterParser(String[] args) {
        this.init(args);
    }

    private void init(String[] args) {
        try {
            if (ContainerHelper.isRunningInContainer()) {
                this.seataEnv = ContainerHelper.getEnv();
                this.host = ContainerHelper.getHost();
                this.port = ContainerHelper.getPort();
                this.serverNode = ContainerHelper.getServerNode();
                this.storeMode = ContainerHelper.getStoreMode();
            } else {
                JCommander jCommander = JCommander.newBuilder().addObject((Object)this).build();
                jCommander.parse(args);
                if (this.help) {
                    jCommander.setProgramName(PROGRAM_NAME);
                    jCommander.usage();
                    System.exit(0);
                }
            }
            if (StringUtils.isNotBlank((String)this.seataEnv)) {
                System.setProperty("seataEnv", this.seataEnv);
            }
            if (StringUtils.isBlank((String)this.storeMode)) {
                this.storeMode = ConfigurationFactory.getInstance().getConfig("store.mode", "file");
            }
        }
        catch (ParameterException e) {
            this.printError(e);
        }
    }

    private void printError(ParameterException e) {
        System.err.println("Option error " + e.getMessage());
        e.getJCommander().setProgramName(PROGRAM_NAME);
        e.usage();
        System.exit(0);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getStoreMode() {
        return this.storeMode;
    }

    public boolean isHelp() {
        return this.help;
    }

    public Long getServerNode() {
        return this.serverNode;
    }

    public String getSeataEnv() {
        return this.seataEnv;
    }

    public void cleanUp() {
        if (null != System.getProperty("seataEnv")) {
            System.clearProperty("seataEnv");
        }
    }
}

