/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.coordinator;

import io.netty.channel.Channel;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.DurationUtil;
import io.seata.config.ConfigurationFactory;
import io.seata.core.event.Event;
import io.seata.core.event.EventBus;
import io.seata.core.event.GlobalTransactionEvent;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import io.seata.core.protocol.transaction.BranchRegisterResponse;
import io.seata.core.protocol.transaction.BranchReportRequest;
import io.seata.core.protocol.transaction.BranchReportResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalLockQueryRequest;
import io.seata.core.protocol.transaction.GlobalLockQueryResponse;
import io.seata.core.protocol.transaction.GlobalReportRequest;
import io.seata.core.protocol.transaction.GlobalReportResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import io.seata.core.protocol.transaction.TCInboundHandler;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.RpcContext;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.ChannelManager;
import io.seata.core.rpc.netty.NettyRemotingServer;
import io.seata.server.AbstractTCInboundHandler;
import io.seata.server.coordinator.DefaultCore;
import io.seata.server.event.EventBusManager;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHelper;
import io.seata.server.session.SessionHolder;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultCoordinator
extends AbstractTCInboundHandler
implements TransactionMessageHandler,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCoordinator.class);
    private static final int TIMED_TASK_SHUTDOWN_MAX_WAIT_MILLS = 5000;
    protected static final long COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.committingRetryPeriod", 1000L);
    protected static final long ASYNC_COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.asynCommittingRetryPeriod", 1000L);
    protected static final long ROLLBACKING_RETRY_PERIOD = CONFIG.getLong("server.recovery.rollbackingRetryPeriod", 1000L);
    protected static final long TIMEOUT_RETRY_PERIOD = CONFIG.getLong("server.recovery.timeoutRetryPeriod", 1000L);
    protected static final long UNDO_LOG_DELETE_PERIOD = CONFIG.getLong("server.undo.logDeletePeriod", 86400000L);
    protected static final long UNDO_LOG_DELAY_DELETE_PERIOD = 180000L;
    private static final int ALWAYS_RETRY_BOUNDARY = 0;
    private static final Duration MAX_COMMIT_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getDuration("server.maxCommitRetryTimeout", DurationUtil.DEFAULT_DURATION, 100L);
    private static final Duration MAX_ROLLBACK_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getDuration("server.maxRollbackRetryTimeout", DurationUtil.DEFAULT_DURATION, 100L);
    private static final boolean ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE = ConfigurationFactory.getInstance().getBoolean("server.rollbackRetryTimeoutUnlockEnable", false);
    private ScheduledThreadPoolExecutor retryRollbacking = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryRollbacking", 1));
    private ScheduledThreadPoolExecutor retryCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryCommitting", 1));
    private ScheduledThreadPoolExecutor asyncCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("AsyncCommitting", 1));
    private ScheduledThreadPoolExecutor timeoutCheck = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("TxTimeoutCheck", 1));
    private ScheduledThreadPoolExecutor undoLogDelete = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("UndoLogDelete", 1));
    private RemotingServer remotingServer;
    private DefaultCore core;
    private EventBus eventBus = EventBusManager.get();

    public DefaultCoordinator(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
        this.core = new DefaultCore(remotingServer);
    }

    @Override
    protected void doGlobalBegin(GlobalBeginRequest request, GlobalBeginResponse response, RpcContext rpcContext) throws TransactionException {
        response.setXid(this.core.begin(rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout()));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction applicationId: {},transactionServiceGroup: {}, transactionName: {},timeout:{},xid:{}", new Object[]{rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout(), response.getXid()});
        }
    }

    @Override
    protected void doGlobalCommit(GlobalCommitRequest request, GlobalCommitResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.commit(request.getXid()));
    }

    @Override
    protected void doGlobalRollback(GlobalRollbackRequest request, GlobalRollbackResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.rollback(request.getXid()));
    }

    @Override
    protected void doGlobalStatus(GlobalStatusRequest request, GlobalStatusResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.getStatus(request.getXid()));
    }

    @Override
    protected void doGlobalReport(GlobalReportRequest request, GlobalReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.globalReport(request.getXid(), request.getGlobalStatus()));
    }

    @Override
    protected void doBranchRegister(BranchRegisterRequest request, BranchRegisterResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setBranchId(this.core.branchRegister(request.getBranchType(), request.getResourceId(), rpcContext.getClientId(), request.getXid(), request.getApplicationData(), request.getLockKey()).longValue());
    }

    @Override
    protected void doBranchReport(BranchReportRequest request, BranchReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(request.getBranchId()));
        this.core.branchReport(request.getBranchType(), request.getXid(), request.getBranchId(), request.getStatus(), request.getApplicationData());
    }

    @Override
    protected void doLockCheck(GlobalLockQueryRequest request, GlobalLockQueryResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setLockable(this.core.lockQuery(request.getBranchType(), request.getResourceId(), request.getXid(), request.getLockKey()));
    }

    protected void timeoutCheck() throws TransactionException {
        Collection<GlobalSession> allSessions = SessionHolder.getRootSessionManager().allSessions();
        if (CollectionUtils.isEmpty(allSessions)) {
            return;
        }
        if (allSessions.size() > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check begin, size: {}", (Object)allSessions.size());
        }
        SessionHelper.forEach(allSessions, globalSession -> {
            boolean shouldTimeout;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(globalSession.getXid() + " " + globalSession.getStatus() + " " + globalSession.getBeginTime() + " " + globalSession.getTimeout());
            }
            if (!(shouldTimeout = SessionHolder.lockAndExecute(globalSession, () -> {
                if (globalSession.getStatus() != GlobalStatus.Begin || !globalSession.isTimeout()) {
                    return false;
                }
                globalSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                globalSession.close();
                globalSession.changeStatus(GlobalStatus.TimeoutRollbacking);
                this.eventBus.post((Event)new GlobalTransactionEvent(globalSession.getTransactionId(), "tc", globalSession.getTransactionName(), globalSession.getApplicationId(), globalSession.getTransactionServiceGroup(), Long.valueOf(globalSession.getBeginTime()), null, globalSession.getStatus()));
                return true;
            }).booleanValue())) {
                return;
            }
            LOGGER.info("Global transaction[{}] is timeout and will be rollback.", (Object)globalSession.getXid());
            globalSession.addSessionLifecycleListener(SessionHolder.getRetryRollbackingSessionManager());
            SessionHolder.getRetryRollbackingSessionManager().addGlobalSession(globalSession);
        });
        if (allSessions.size() > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check end. ");
        }
    }

    protected void handleRetryRollbacking() {
        Collection<GlobalSession> rollbackingSessions = SessionHolder.getRetryRollbackingSessionManager().allSessions();
        if (CollectionUtils.isEmpty(rollbackingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(rollbackingSessions, rollbackingSession -> {
            try {
                if (rollbackingSession.getStatus().equals((Object)GlobalStatus.Rollbacking) && !rollbackingSession.isDeadSession()) {
                    return;
                }
                if (this.isRetryTimeout(now, MAX_ROLLBACK_RETRY_TIMEOUT.toMillis(), rollbackingSession.getBeginTime())) {
                    if (ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE) {
                        rollbackingSession.clean();
                    }
                    SessionHolder.getRetryRollbackingSessionManager().removeGlobalSession(rollbackingSession);
                    LOGGER.info("Global transaction rollback retry timeout and has removed [{}]", (Object)rollbackingSession.getXid());
                    return;
                }
                rollbackingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalRollback(rollbackingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.info("Failed to retry rollbacking [{}] {} {}", new Object[]{rollbackingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    protected void handleRetryCommitting() {
        Collection<GlobalSession> committingSessions = SessionHolder.getRetryCommittingSessionManager().allSessions();
        if (CollectionUtils.isEmpty(committingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(committingSessions, committingSession -> {
            try {
                if (committingSession.getStatus().equals((Object)GlobalStatus.Committing) && !committingSession.isDeadSession()) {
                    return;
                }
                if (this.isRetryTimeout(now, MAX_COMMIT_RETRY_TIMEOUT.toMillis(), committingSession.getBeginTime())) {
                    SessionHolder.getRetryCommittingSessionManager().removeGlobalSession(committingSession);
                    LOGGER.error("Global transaction commit retry timeout and has removed [{}]", (Object)committingSession.getXid());
                    return;
                }
                committingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalCommit(committingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.info("Failed to retry committing [{}] {} {}", new Object[]{committingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    private boolean isRetryTimeout(long now, long timeout, long beginTime) {
        return timeout >= 0L && now - beginTime > timeout;
    }

    protected void handleAsyncCommitting() {
        Collection<GlobalSession> asyncCommittingSessions = SessionHolder.getAsyncCommittingSessionManager().allSessions();
        if (CollectionUtils.isEmpty(asyncCommittingSessions)) {
            return;
        }
        SessionHelper.forEach(asyncCommittingSessions, asyncCommittingSession -> {
            try {
                if (GlobalStatus.AsyncCommitting != asyncCommittingSession.getStatus()) {
                    return;
                }
                asyncCommittingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalCommit(asyncCommittingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to async committing [{}] {} {}", new Object[]{asyncCommittingSession.getXid(), ex.getCode(), ex.getMessage(), ex});
            }
        });
    }

    protected void undoLogDelete() {
        Map rmChannels = ChannelManager.getRmChannels();
        if (rmChannels == null || rmChannels.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no active rm channels to delete undo log");
            }
            return;
        }
        short saveDays = CONFIG.getShort("server.undo.logSaveDays", (short)7);
        for (Map.Entry channelEntry : rmChannels.entrySet()) {
            String resourceId = (String)channelEntry.getKey();
            UndoLogDeleteRequest deleteRequest = new UndoLogDeleteRequest();
            deleteRequest.setResourceId(resourceId);
            deleteRequest.setSaveDays(saveDays > 0 ? saveDays : (short)7);
            try {
                this.remotingServer.sendAsyncRequest((Channel)channelEntry.getValue(), (Object)deleteRequest);
            }
            catch (Exception e) {
                LOGGER.error("Failed to async delete undo log resourceId = {}, exception: {}", (Object)resourceId, (Object)e.getMessage());
            }
        }
    }

    public void init() {
        this.retryRollbacking.scheduleAtFixedRate(() -> {
            boolean lock = SessionHolder.retryRollbackingLock();
            if (lock) {
                try {
                    this.handleRetryRollbacking();
                }
                catch (Exception e) {
                    LOGGER.info("Exception retry rollbacking ... ", (Throwable)e);
                }
                finally {
                    SessionHolder.unRetryRollbackingLock();
                }
            }
        }, 0L, ROLLBACKING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.retryCommitting.scheduleAtFixedRate(() -> {
            boolean lock = SessionHolder.retryCommittingLock();
            if (lock) {
                try {
                    this.handleRetryCommitting();
                }
                catch (Exception e) {
                    LOGGER.info("Exception retry committing ... ", (Throwable)e);
                }
                finally {
                    SessionHolder.unRetryCommittingLock();
                }
            }
        }, 0L, COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.asyncCommitting.scheduleAtFixedRate(() -> {
            boolean lock = SessionHolder.asyncCommittingLock();
            if (lock) {
                try {
                    this.handleAsyncCommitting();
                }
                catch (Exception e) {
                    LOGGER.info("Exception async committing ... ", (Throwable)e);
                }
                finally {
                    SessionHolder.unAsyncCommittingLock();
                }
            }
        }, 0L, ASYNC_COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.timeoutCheck.scheduleAtFixedRate(() -> {
            boolean lock = SessionHolder.txTimeoutCheckLock();
            if (lock) {
                try {
                    this.timeoutCheck();
                }
                catch (Exception e) {
                    LOGGER.info("Exception timeout checking ... ", (Throwable)e);
                }
                finally {
                    SessionHolder.unTxTimeoutCheckLock();
                }
            }
        }, 0L, TIMEOUT_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.undoLogDelete.scheduleAtFixedRate(() -> {
            boolean lock = SessionHolder.undoLogDeleteLock();
            if (lock) {
                try {
                    this.undoLogDelete();
                }
                catch (Exception e) {
                    LOGGER.info("Exception undoLog deleting ... ", (Throwable)e);
                }
                finally {
                    SessionHolder.unUndoLogDeleteLock();
                }
            }
        }, 180000L, UNDO_LOG_DELETE_PERIOD, TimeUnit.MILLISECONDS);
    }

    public AbstractResultMessage onRequest(AbstractMessage request, RpcContext context) {
        if (!(request instanceof AbstractTransactionRequestToTC)) {
            throw new IllegalArgumentException();
        }
        AbstractTransactionRequestToTC transactionRequest = (AbstractTransactionRequestToTC)request;
        transactionRequest.setTCInboundHandler((TCInboundHandler)this);
        return transactionRequest.handle(context);
    }

    public void onResponse(AbstractResultMessage response, RpcContext context) {
        if (!(response instanceof AbstractTransactionResponse)) {
            throw new IllegalArgumentException();
        }
    }

    public void destroy() {
        this.retryRollbacking.shutdown();
        this.retryCommitting.shutdown();
        this.asyncCommitting.shutdown();
        this.timeoutCheck.shutdown();
        try {
            this.retryRollbacking.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.retryCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.asyncCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.timeoutCheck.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.remotingServer instanceof NettyRemotingServer) {
            ((NettyRemotingServer)this.remotingServer).destroy();
        }
        SessionHolder.destroy();
    }
}

