/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.StoreMode;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.Reloadable;
import io.seata.server.session.SessionManager;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionHolder.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    public static final String ROOT_SESSION_MANAGER_NAME = "root.data";
    public static final String ASYNC_COMMITTING_SESSION_MANAGER_NAME = "async.commit.data";
    public static final String RETRY_COMMITTING_SESSION_MANAGER_NAME = "retry.commit.data";
    public static final String RETRY_ROLLBACKING_SESSION_MANAGER_NAME = "retry.rollback.data";
    public static final String DEFAULT_SESSION_STORE_FILE_DIR = "sessionStore";
    private static SessionManager ROOT_SESSION_MANAGER;
    private static SessionManager ASYNC_COMMITTING_SESSION_MANAGER;
    private static SessionManager RETRY_COMMITTING_SESSION_MANAGER;
    private static SessionManager RETRY_ROLLBACKING_SESSION_MANAGER;

    public static void init(String mode) {
        StoreMode storeMode;
        if (StringUtils.isBlank((String)mode)) {
            mode = CONFIG.getConfig("store.mode");
        }
        if (StoreMode.DB.equals((Object)(storeMode = StoreMode.get((String)mode)))) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName());
            ASYNC_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{ASYNC_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{RETRY_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_ROLLBACKING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.DB.getName(), (Object[])new Object[]{RETRY_ROLLBACKING_SESSION_MANAGER_NAME});
        } else if (StoreMode.FILE.equals((Object)storeMode)) {
            String sessionStorePath = CONFIG.getConfig("store.file.dir", DEFAULT_SESSION_STORE_FILE_DIR);
            if (StringUtils.isBlank((String)sessionStorePath)) {
                throw new StoreException("the {store.file.dir} is empty.");
            }
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.FILE.getName(), (Object[])new Object[]{ROOT_SESSION_MANAGER_NAME, sessionStorePath});
            ASYNC_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.FILE.getName(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{ASYNC_COMMITTING_SESSION_MANAGER_NAME, null});
            RETRY_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.FILE.getName(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{RETRY_COMMITTING_SESSION_MANAGER_NAME, null});
            RETRY_ROLLBACKING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.FILE.getName(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{RETRY_ROLLBACKING_SESSION_MANAGER_NAME, null});
        } else if (StoreMode.REDIS.equals((Object)storeMode)) {
            ROOT_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName());
            ASYNC_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{ASYNC_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_COMMITTING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{RETRY_COMMITTING_SESSION_MANAGER_NAME});
            RETRY_ROLLBACKING_SESSION_MANAGER = (SessionManager)EnhancedServiceLoader.load(SessionManager.class, (String)StoreMode.REDIS.getName(), (Object[])new Object[]{RETRY_ROLLBACKING_SESSION_MANAGER_NAME});
        } else {
            throw new IllegalArgumentException("unknown store mode:" + mode);
        }
        SessionHolder.reload(storeMode);
    }

    protected static void reload(StoreMode storeMode) {
        Collection<GlobalSession> allSessions;
        if (ROOT_SESSION_MANAGER instanceof Reloadable) {
            ((Reloadable)((Object)ROOT_SESSION_MANAGER)).reload();
        }
        if (CollectionUtils.isNotEmpty(allSessions = ROOT_SESSION_MANAGER.allSessions())) {
            ArrayList<GlobalSession> removeGlobalSessions = new ArrayList<GlobalSession>();
            block9: for (GlobalSession globalSession : allSessions) {
                GlobalStatus globalStatus = globalSession.getStatus();
                switch (globalStatus) {
                    case UnKnown: 
                    case Committed: 
                    case CommitFailed: 
                    case Rollbacked: 
                    case RollbackFailed: 
                    case TimeoutRollbacked: 
                    case TimeoutRollbackFailed: 
                    case Finished: {
                        removeGlobalSessions.add(globalSession);
                        continue block9;
                    }
                    case AsyncCommitting: {
                        if (storeMode != StoreMode.FILE) continue block9;
                        SessionHolder.queueToAsyncCommitting(globalSession);
                        continue block9;
                    }
                }
                if (storeMode != StoreMode.FILE) continue;
                SessionHolder.lockBranchSessions(globalSession.getSortedBranches());
                switch (globalStatus) {
                    case Committing: 
                    case CommitRetrying: {
                        SessionHolder.queueToRetryCommit(globalSession);
                        continue block9;
                    }
                    case Rollbacking: 
                    case RollbackRetrying: 
                    case TimeoutRollbacking: 
                    case TimeoutRollbackRetrying: {
                        SessionHolder.queueToRetryRollback(globalSession);
                        continue block9;
                    }
                    case Begin: {
                        globalSession.setActive(true);
                        continue block9;
                    }
                }
                throw new ShouldNeverHappenException("NOT properly handled " + globalStatus);
            }
            for (GlobalSession globalSession : removeGlobalSessions) {
                SessionHolder.removeInErrorState(globalSession);
            }
        }
    }

    private static void removeInErrorState(GlobalSession globalSession) {
        try {
            LOGGER.warn("The global session should NOT be {}, remove it. xid = {}", (Object)globalSession.getStatus(), (Object)globalSession.getXid());
            ROOT_SESSION_MANAGER.removeGlobalSession(globalSession);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Remove global session succeed, xid = {}, status = {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        catch (Exception e) {
            LOGGER.error("Remove global session failed, xid = {}, status = {}", new Object[]{globalSession.getXid(), globalSession.getStatus(), e});
        }
    }

    private static void queueToAsyncCommitting(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getAsyncCommittingSessionManager());
            SessionHolder.getAsyncCommittingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    private static void lockBranchSessions(ArrayList<BranchSession> branchSessions) {
        branchSessions.forEach(branchSession -> {
            try {
                branchSession.lock();
            }
            catch (TransactionException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        });
    }

    private static void queueToRetryCommit(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getRetryCommittingSessionManager());
            SessionHolder.getRetryCommittingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    private static void queueToRetryRollback(GlobalSession globalSession) {
        try {
            globalSession.addSessionLifecycleListener(SessionHolder.getRetryRollbackingSessionManager());
            SessionHolder.getRetryRollbackingSessionManager().addGlobalSession(globalSession);
        }
        catch (TransactionException e) {
            throw new ShouldNeverHappenException((Throwable)e);
        }
    }

    public static SessionManager getRootSessionManager() {
        if (ROOT_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return ROOT_SESSION_MANAGER;
    }

    public static SessionManager getAsyncCommittingSessionManager() {
        if (ASYNC_COMMITTING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return ASYNC_COMMITTING_SESSION_MANAGER;
    }

    public static SessionManager getRetryCommittingSessionManager() {
        if (RETRY_COMMITTING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return RETRY_COMMITTING_SESSION_MANAGER;
    }

    public static SessionManager getRetryRollbackingSessionManager() {
        if (RETRY_ROLLBACKING_SESSION_MANAGER == null) {
            throw new ShouldNeverHappenException("SessionManager is NOT init!");
        }
        return RETRY_ROLLBACKING_SESSION_MANAGER;
    }

    public static GlobalSession findGlobalSession(String xid) {
        return SessionHolder.findGlobalSession(xid, true);
    }

    public static GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return SessionHolder.getRootSessionManager().findGlobalSession(xid, withBranchSessions);
    }

    public static <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        return SessionHolder.getRootSessionManager().lockAndExecute(globalSession, lockCallable);
    }

    public static boolean retryRollbackingLock() {
        return SessionHolder.getRootSessionManager().scheduledLock("RetryRollbacking");
    }

    public static boolean retryCommittingLock() {
        return SessionHolder.getRootSessionManager().scheduledLock("RetryCommitting");
    }

    public static boolean asyncCommittingLock() {
        return SessionHolder.getRootSessionManager().scheduledLock("AsyncCommitting");
    }

    public static boolean txTimeoutCheckLock() {
        return SessionHolder.getRootSessionManager().scheduledLock("TxTimeoutCheck");
    }

    public static boolean undoLogDeleteLock() {
        return SessionHolder.getRootSessionManager().scheduledLock("UndologDelete");
    }

    public static boolean unRetryRollbackingLock() {
        return SessionHolder.getRootSessionManager().unScheduledLock("RetryRollbacking");
    }

    public static boolean unRetryCommittingLock() {
        return SessionHolder.getRootSessionManager().unScheduledLock("RetryCommitting");
    }

    public static boolean unAsyncCommittingLock() {
        return SessionHolder.getRootSessionManager().unScheduledLock("AsyncCommitting");
    }

    public static boolean unTxTimeoutCheckLock() {
        return SessionHolder.getRootSessionManager().unScheduledLock("TxTimeoutCheck");
    }

    public static boolean unUndoLogDeleteLock() {
        return SessionHolder.getRootSessionManager().unScheduledLock("UndologDelete");
    }

    public static void destroy() {
        if (ROOT_SESSION_MANAGER != null) {
            ROOT_SESSION_MANAGER.destroy();
        }
        if (ASYNC_COMMITTING_SESSION_MANAGER != null) {
            ASYNC_COMMITTING_SESSION_MANAGER.destroy();
        }
        if (RETRY_COMMITTING_SESSION_MANAGER != null) {
            RETRY_COMMITTING_SESSION_MANAGER.destroy();
        }
        if (RETRY_ROLLBACKING_SESSION_MANAGER != null) {
            RETRY_ROLLBACKING_SESSION_MANAGER.destroy();
        }
    }
}

