/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.db.store;

import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.model.GlobalStatus;
import io.seata.core.store.BranchTransactionDO;
import io.seata.core.store.GlobalTransactionDO;
import io.seata.core.store.LogStore;
import io.seata.core.store.db.DataSourceProvider;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.SessionConverter;
import io.seata.server.storage.db.store.LogStoreDataBaseDAO;
import io.seata.server.store.AbstractTransactionStoreManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class DataBaseTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager {
    private static volatile DataBaseTransactionStoreManager instance;
    protected static final Configuration CONFIG;
    protected static final int DEFAULT_LOG_QUERY_LIMIT = 100;
    protected LogStore logStore;
    protected int logQueryLimit = CONFIG.getInt("store.db.queryLimit", 100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataBaseTransactionStoreManager getInstance() {
        if (instance != null) return instance;
        Class<DataBaseTransactionStoreManager> clazz = DataBaseTransactionStoreManager.class;
        synchronized (DataBaseTransactionStoreManager.class) {
            if (instance != null) return instance;
            instance = new DataBaseTransactionStoreManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DataBaseTransactionStoreManager() {
        String datasourceType = CONFIG.getConfig("store.db.datasource");
        DataSource logStoreDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)datasourceType)).provide();
        this.logStore = new LogStoreDataBaseDAO(logStoreDataSource);
    }

    @Override
    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        if (TransactionStoreManager.LogOperation.GLOBAL_ADD.equals((Object)logOperation)) {
            return this.logStore.insertGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_UPDATE.equals((Object)logOperation)) {
            return this.logStore.updateGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.GLOBAL_REMOVE.equals((Object)logOperation)) {
            return this.logStore.deleteGlobalTransactionDO(SessionConverter.convertGlobalTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_ADD.equals((Object)logOperation)) {
            return this.logStore.insertBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_UPDATE.equals((Object)logOperation)) {
            return this.logStore.updateBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        if (TransactionStoreManager.LogOperation.BRANCH_REMOVE.equals((Object)logOperation)) {
            return this.logStore.deleteBranchTransactionDO(SessionConverter.convertBranchTransactionDO(session));
        }
        throw new StoreException("Unknown LogOperation:" + logOperation.name());
    }

    public GlobalSession readSession(Long transactionId) {
        GlobalTransactionDO globalTransactionDO = this.logStore.queryGlobalTransactionDO(transactionId.longValue());
        if (globalTransactionDO == null) {
            return null;
        }
        List branchTransactionDOs = this.logStore.queryBranchTransactionDO(globalTransactionDO.getXid());
        return this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
    }

    @Override
    public GlobalSession readSession(String xid) {
        return this.readSession(xid, true);
    }

    @Override
    public GlobalSession readSession(String xid, boolean withBranchSessions) {
        GlobalTransactionDO globalTransactionDO = this.logStore.queryGlobalTransactionDO(xid);
        if (globalTransactionDO == null) {
            return null;
        }
        List branchTransactionDOs = null;
        if (withBranchSessions) {
            branchTransactionDOs = this.logStore.queryBranchTransactionDO(globalTransactionDO.getXid());
        }
        return this.getGlobalSession(globalTransactionDO, branchTransactionDOs);
    }

    public List<GlobalSession> readSession(GlobalStatus[] statuses) {
        int[] states = new int[statuses.length];
        for (int i = 0; i < statuses.length; ++i) {
            states[i] = statuses[i].getCode();
        }
        List globalTransactionDOs = this.logStore.queryGlobalTransactionDO(states, this.logQueryLimit);
        if (CollectionUtils.isEmpty((Collection)globalTransactionDOs)) {
            return null;
        }
        List xids = globalTransactionDOs.stream().map(GlobalTransactionDO::getXid).collect(Collectors.toList());
        List branchTransactionDOs = this.logStore.queryBranchTransactionDO(xids);
        Map branchTransactionDOsMap = branchTransactionDOs.stream().collect(Collectors.groupingBy(BranchTransactionDO::getXid, LinkedHashMap::new, Collectors.toList()));
        return globalTransactionDOs.stream().map(globalTransactionDO -> this.getGlobalSession((GlobalTransactionDO)globalTransactionDO, (List)branchTransactionDOsMap.get(globalTransactionDO.getXid()))).collect(Collectors.toList());
    }

    @Override
    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        if (StringUtils.isNotBlank((String)sessionCondition.getXid())) {
            GlobalSession globalSession = this.readSession(sessionCondition.getXid());
            if (globalSession != null) {
                ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
                globalSessions.add(globalSession);
                return globalSessions;
            }
        } else if (sessionCondition.getTransactionId() != null) {
            GlobalSession globalSession = this.readSession(sessionCondition.getTransactionId());
            if (globalSession != null) {
                ArrayList<GlobalSession> globalSessions = new ArrayList<GlobalSession>();
                globalSessions.add(globalSession);
                return globalSessions;
            }
        } else if (CollectionUtils.isNotEmpty((Object[])sessionCondition.getStatuses())) {
            return this.readSession(sessionCondition.getStatuses());
        }
        return null;
    }

    private GlobalSession getGlobalSession(GlobalTransactionDO globalTransactionDO, List<BranchTransactionDO> branchTransactionDOs) {
        GlobalSession globalSession = SessionConverter.convertGlobalSession(globalTransactionDO);
        if (CollectionUtils.isNotEmpty(branchTransactionDOs)) {
            for (BranchTransactionDO branchTransactionDO : branchTransactionDOs) {
                globalSession.add(SessionConverter.convertBranchSession(branchTransactionDO));
            }
        }
        return globalSession;
    }

    public void setLogStore(LogStore logStore) {
        this.logStore = logStore;
    }

    public void setLogQueryLimit(int logQueryLimit) {
        this.logQueryLimit = logQueryLimit;
    }

    static {
        CONFIG = ConfigurationFactory.getInstance();
    }
}

