/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.store;

import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.server.storage.file.FlushDiskMode;

public class StoreConfig {
    private static final Configuration CONFIGURATION = ConfigurationFactory.getInstance();
    private static final int DEFAULT_MAX_BRANCH_SESSION_SIZE = 16384;
    private static final int DEFAULT_MAX_GLOBAL_SESSION_SIZE = 512;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 16384;

    public static int getMaxBranchSessionSize() {
        return CONFIGURATION.getInt("store.file.maxBranchSessionSize", 16384);
    }

    public static int getMaxGlobalSessionSize() {
        return CONFIGURATION.getInt("store.file.maxGlobalSessionSize", 512);
    }

    public static int getFileWriteBufferCacheSize() {
        return CONFIGURATION.getInt("store.file.fileWriteBufferCacheSize", 16384);
    }

    public static FlushDiskMode getFlushDiskMode() {
        return FlushDiskMode.findDiskMode(CONFIGURATION.getConfig("store.file.flushDiskMode"));
    }
}

