/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.api.ConfigMapContext;
import io.shardingsphere.api.config.rule.MasterSlaveRuleConfiguration;
import io.shardingsphere.api.config.rule.RuleConfiguration;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.orchestration.config.OrchestrationConfiguration;
import io.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import io.shardingsphere.orchestration.internal.registry.config.event.ConfigMapChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.MasterSlaveRuleChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import io.shardingsphere.orchestration.internal.registry.config.service.ConfigurationService;
import io.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import io.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import io.shardingsphere.shardingjdbc.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.circuit.datasource.CircuitBreakerDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import io.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OrchestrationMasterSlaveDataSource
extends AbstractOrchestrationDataSource {
    private MasterSlaveDataSource dataSource;

    public OrchestrationMasterSlaveDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigurationService configService = this.getShardingOrchestrationFacade().getConfigService();
        MasterSlaveRuleConfiguration masterSlaveRuleConfig = configService.loadMasterSlaveRuleConfiguration("logic_db");
        Preconditions.checkState((null != masterSlaveRuleConfig && !Strings.isNullOrEmpty((String)masterSlaveRuleConfig.getMasterDataSourceName()) ? 1 : 0) != 0, (Object)"No available master slave rule configuration to load.");
        this.dataSource = new MasterSlaveDataSource(DataSourceConverter.getDataSourceMap(configService.loadDataSourceConfigurations("logic_db")), (MasterSlaveRule)new OrchestrationMasterSlaveRule(masterSlaveRuleConfig), configService.loadConfigMap(), configService.loadProperties());
        this.getShardingOrchestrationFacade().init();
    }

    public OrchestrationMasterSlaveDataSource(MasterSlaveDataSource masterSlaveDataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")), masterSlaveDataSource.getDataSourceMap());
        this.dataSource = new MasterSlaveDataSource(masterSlaveDataSource.getDataSourceMap(), (MasterSlaveRule)new OrchestrationMasterSlaveRule(masterSlaveDataSource.getMasterSlaveRule().getMasterSlaveRuleConfiguration()), ConfigMapContext.getInstance().getConfigMap(), masterSlaveDataSource.getShardingProperties().getProps());
        this.getShardingOrchestrationFacade().init(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(this.dataSource.getDataSourceMap())), this.getRuleConfigurationMap(), null, ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingProperties().getProps());
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        MasterSlaveRule masterSlaveRule = this.dataSource.getMasterSlaveRule();
        HashMap<String, RuleConfiguration> result = new HashMap<String, RuleConfiguration>();
        result.put("logic_db", (RuleConfiguration)new MasterSlaveRuleConfiguration(masterSlaveRule.getName(), masterSlaveRule.getMasterDataSourceName(), masterSlaveRule.getSlaveDataSourceNames(), masterSlaveRule.getLoadBalanceAlgorithm()));
        return result;
    }

    public final Connection getConnection() {
        return this.isCircuitBreak() ? new CircuitBreakerDataSource().getConnection() : this.dataSource.getConnection();
    }

    public final void close() {
        this.dataSource.close();
        this.getShardingOrchestrationFacade().close();
    }

    @Subscribe
    public final synchronized void renew(MasterSlaveRuleChangedEvent masterSlaveRuleChangedEvent) throws SQLException {
        this.dataSource = new MasterSlaveDataSource(this.dataSource.getDataSourceMap(), masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration(), ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        this.dataSource.close();
        this.dataSource = new MasterSlaveDataSource(DataSourceConverter.getDataSourceMap(dataSourceChangedEvent.getDataSourceConfigurations()), this.dataSource.getMasterSlaveRule(), ConfigMapContext.getInstance().getConfigMap(), this.dataSource.getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new MasterSlaveDataSource(this.dataSource.getDataSourceMap(), this.dataSource.getMasterSlaveRule(), ConfigMapContext.getInstance().getConfigMap(), propertiesChangedEvent.getProps());
    }

    @Subscribe
    public final synchronized void renew(ConfigMapChangedEvent configMapChangedEvent) {
        ConfigMapContext.getInstance().getConfigMap().clear();
        ConfigMapContext.getInstance().getConfigMap().putAll(configMapChangedEvent.getConfigMap());
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if ("logic_db".equals(shardingSchema.getSchemaName())) {
            ((OrchestrationMasterSlaveRule)this.dataSource.getMasterSlaveRule()).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
        }
    }
}

